/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.visualizer;

import com.sun.j3d.utils.geometry.Cylinder;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.freedrive.internal.state.SingularityStateHolder;
import com.ur.polyscope.freedrive.internal.state.SingularityType;
import com.ur.polyscope.freedrive.internal.visualizer.SingularityVisualization;
import com.ur.polyscope.robot.configuration.kinematics.DHParameters;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsFactory;
import com.ur.polyscope.robot.configuration.visualization.SingularityVisualizationConfiguration;
import com.ur.polyscope.robot.configuration.visualization.SingularityVisualizationProvider;
import javax.inject.Inject;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.AxisAngle4d;

public class ElbowSingularityVisualization
extends SingularityVisualization {
    private final SingularityVisualizationConfiguration visualizationConf;

    @Inject
    public ElbowSingularityVisualization(@Source(value=SingularityStateHolder.class) Recipe<SingularityStateHolder> singularityStateHolder, @Source(value=Arm.class) Recipe<Arm> armRecipe, @Source(value=DHParameters.class) Recipe<DHParameters> dhParametersRecipe, KinematicsFactory kinematicsFactory, SingularityVisualizationProvider visualizationProvider) {
        super(singularityStateHolder, armRecipe, dhParametersRecipe, kinematicsFactory);
        this.visualizationConf = visualizationProvider.getSingularityVisualization();
    }

    @Override
    protected SingularityType getSingularityType() {
        return SingularityType.ELBOW;
    }

    @Override
    protected Node getVisualizerNode(Appearance appearance) {
        this.updateAppearance(appearance);
        appearance.setTransparencyAttributes(new TransparencyAttributes(0, 0.15f));
        TransformGroup cylinderTransformGroup = new TransformGroup();
        Cylinder elbowCylinder = new Cylinder(this.visualizationConf.getElbowCylinderRadius(), this.visualizationConf.getElbowCylinderLength(), appearance);
        cylinderTransformGroup.addChild((Node)elbowCylinder);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(this.visualizationConf.getElbowCylinderTranslation());
        transform3D.setRotation(new AxisAngle4d(1.0, 0.0, 0.0, 1.5707963267948966));
        cylinderTransformGroup.setTransform(transform3D);
        return cylinderTransformGroup;
    }

    @Override
    protected JointType getVisualizerJoint() {
        return JointType.ELBOW;
    }
}

