/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.visualizer;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.freedrive.internal.state.SingularityState;
import com.ur.polyscope.freedrive.internal.state.SingularityStateHolder;
import com.ur.polyscope.freedrive.internal.state.SingularityType;
import com.ur.polyscope.robot.configuration.kinematics.DHParameters;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsFactory;
import com.ur.polyscope.visualizer.element.VisualizerElement;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.utils.MaterialDB;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TransformGroup;

public abstract class SingularityVisualization
implements VisualizerElement {
    protected final Provider<SingularityStateHolder> singularityStateHolderProvider;
    private final Provider<Arm> armRecipeProvider;
    private final KinematicsFactory kinematicsFactory;
    private final Provider<DHParameters> dhParametersProvide;
    private KinematicsCalibration kinematicsCalibration;
    private BranchGroup branchGroup;
    private BranchGroup subBranchGroup;
    private RenderingAttributes renderingAttributes;
    private Appearance appearance;
    private TransformGroup individualTransformGroup;
    public static final Material NEAR_SINGULARITY_MATERIAL = MaterialDB.get((MaterialDB.MaterialID)MaterialDB.MaterialID.YELLOW_RUBBER);
    public static final Material IN_SINGULARITY_MATERIAL = MaterialDB.get((MaterialDB.MaterialID)MaterialDB.MaterialID.RED_RUBBER);

    @Inject
    public SingularityVisualization(@Source(value=SingularityStateHolder.class) Recipe<SingularityStateHolder> singularityStateHolder, @Source(value=Arm.class) Recipe<Arm> armRecipe, @Source(value=DHParameters.class) Recipe<DHParameters> dhParametersRecipe, KinematicsFactory kinematicsFactory) {
        this.singularityStateHolderProvider = singularityStateHolder.lastProvider();
        this.armRecipeProvider = armRecipe.lastProvider();
        this.kinematicsFactory = kinematicsFactory;
        this.dhParametersProvide = dhParametersRecipe.lastProvider();
    }

    public Node getElementNode() {
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(13);
        this.branchGroup.setCapability(14);
        this.subBranchGroup = new BranchGroup();
        this.renderingAttributes = new RenderingAttributes();
        this.renderingAttributes.setCapability(6);
        this.renderingAttributes.setVisible(false);
        BranchGroup result = this.branchGroup;
        this.appearance = new Appearance();
        this.appearance.setRenderingAttributes(this.renderingAttributes);
        this.appearance.setCapability(1);
        return result;
    }

    public void update() {
        this.updateKinematicsCalibration();
        if (!this.canVisualize()) {
            this.renderingAttributes.setVisible(false);
            return;
        }
        if (this.individualTransformGroup == null) {
            this.createVisualization();
        }
        this.renderingAttributes.setVisible(this.isVisible());
        this.updateAppearance(this.appearance);
        JointPositionVector jointsPosition = ((Arm)this.armRecipeProvider.get()).getActualJointsPosition();
        this.individualTransformGroup.setTransform(this.kinematicsCalibration.getBaseToJoint(jointsPosition, this.getVisualizerJoint()));
    }

    protected void createVisualization() {
        this.individualTransformGroup = new TransformGroup();
        this.individualTransformGroup.addChild(this.getVisualizerNode(this.appearance));
        this.individualTransformGroup.setCapability(18);
        this.individualTransformGroup.setCapability(13);
        this.subBranchGroup.addChild((Node)this.individualTransformGroup);
        this.branchGroup.addChild((Node)this.subBranchGroup);
    }

    private void updateKinematicsCalibration() {
        if (this.kinematicsCalibration != null) {
            return;
        }
        DHParameters dhParameters = (DHParameters)this.dhParametersProvide.get();
        if (dhParameters == null) {
            return;
        }
        this.kinematicsCalibration = this.kinematicsFactory.createKinematicsCalibration(dhParameters.theta(), dhParameters.a(), dhParameters.d(), dhParameters.alpha(), null, null, true);
    }

    protected abstract Node getVisualizerNode(Appearance var1);

    protected void updateAppearance(Appearance appearance) {
        switch (((SingularityStateHolder)this.singularityStateHolderProvider.get()).getSingularityState()) {
            case NEAR_SINGULARITY: {
                appearance.setMaterial(NEAR_SINGULARITY_MATERIAL);
                break;
            }
            case IN_SINGULARITY: {
                appearance.setMaterial(IN_SINGULARITY_MATERIAL);
                break;
            }
        }
    }

    protected abstract JointType getVisualizerJoint();

    private boolean canVisualize() {
        return this.armRecipeProvider.get() != null && this.kinematicsCalibration != null && this.singularityStateHolderProvider.get() != null;
    }

    public boolean isVisible() {
        SingularityStateHolder currentStateHolder = (SingularityStateHolder)this.singularityStateHolderProvider.get();
        return currentStateHolder.getSingularityState() != SingularityState.INACTIVE && currentStateHolder.getSingularityTypes().contains((Object)this.getSingularityType());
    }

    protected abstract SingularityType getSingularityType();

    public VisualizerElementType getElementType() {
        return VisualizerElementType.CONSTRAINED_FREE_DRIVE;
    }
}

