/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.concept.operations.internal;

import com.ur.polyscope.concept.operations.ProgramInstallationService;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.concept.operations.location.ConceptLocationFactory;
import com.ur.polyscope.concept.operations.location.Types;
import com.ur.polyscope.concept.operations.resource.InstallationResource;
import com.ur.polyscope.concept.operations.resource.ProgramResource;
import com.ur.polyscope.concept.operations.resource.VariableResource;
import javax.inject.Inject;

public class ProgramInstallationServiceDummy
implements ProgramInstallationService {
    private final ConceptLocationFactory conceptLocationFactory;

    @Inject
    public ProgramInstallationServiceDummy(ConceptLocationFactory conceptLocationFactory) {
        this.conceptLocationFactory = conceptLocationFactory;
    }

    @Override
    public ProgramResource getProgram(ConceptLocation source) {
        return new DummyProgramResource(source);
    }

    @Override
    public InstallationResource getInstallation(ConceptLocation source) {
        return new DummyInstallationResource(source);
    }

    private class DummyInstallationResource
    implements InstallationResource {
        private final ConceptLocation location;
        private final VariableResource variables;

        public DummyInstallationResource(ConceptLocation location) {
            this.location = location;
            ConceptLocation variableLocation = ProgramInstallationServiceDummy.this.conceptLocationFactory.get(location.getName(), location.getPath(), Types.getVariable());
            this.variables = new VariableResource(variableLocation, false);
        }

        @Override
        public VariableResource getVariables() {
            return this.variables;
        }

        @Override
        public ConceptLocation getLocation() {
            return this.location;
        }

        @Override
        public boolean exists() {
            return false;
        }
    }

    private class DummyProgramResource
    implements ProgramResource {
        private final ConceptLocation location;
        private final InstallationResource installation;

        public DummyProgramResource(ConceptLocation source) {
            this.location = source;
            ConceptLocation installationLocation = ProgramInstallationServiceDummy.this.conceptLocationFactory.get(this.location.getName(), this.location.getPath(), Types.getInstallation());
            this.installation = new DummyInstallationResource(installationLocation);
        }

        @Override
        public InstallationResource getInstallation() {
            return this.installation;
        }

        @Override
        public boolean setInstallation(InstallationResource installation) {
            return true;
        }

        @Override
        public boolean setInstallation(ConceptLocation installationLocation) {
            return true;
        }

        @Override
        public ConceptLocation getLocation() {
            return this.location;
        }

        @Override
        public boolean exists() {
            return false;
        }
    }
}

