/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.swing.driver;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import java.awt.Dimension;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JFrame;

class AbstractIntegrationSupportDriver
extends BaseDriver {
    private static JFrame frame;

    protected AbstractIntegrationSupportDriver(MainScreen mainScreen, String driverShowingComponentName) {
        super(mainScreen, driverShowingComponentName);
    }

    public static void launchInFrame(final JComponent component, Dimension dimensions) {
        if (frame != null) {
            throw new AlreadyRunningException();
        }
        frame = new JFrame();
        frame.add(component);
        frame.setSize(dimensions);
        frame.setName("urgui.URGUI");
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return component.isVisible();
            }
        }, (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public void wrapUp() {
        try {
            if (frame == null) {
                return;
            }
            frame.setVisible(false);
            frame.dispose();
            Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                public boolean itHappened() {
                    return !frame.isDisplayable();
                }
            }, (int)30, (TimeUnit)TimeUnit.SECONDS);
            frame = null;
        }
        catch (Exception e) {
            Log.error((String)"Failed to dispose frame", (Throwable)e);
        }
    }

    private static class AlreadyRunningException
    extends RuntimeException {
        private AlreadyRunningException() {
        }
    }
}

