/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.swing.driver;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.gripper.swing.driver.ActionAlreadyToggled;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.JCheckBoxOperator;

public class ActionOutcomeDriver
extends BaseDriver {
    public static final String SUCCESS_CARD = "SuccessCard";
    public static final String SWITCH_ACTION = "actionSwitch.ActionPanel";
    public static final String TIMEOUT = "timeout.TimeoutCard";

    @Inject
    public ActionOutcomeDriver(MainScreen mainScreen) {
        super(mainScreen, "programNode-action-outcome-driver");
    }

    public static ActionOutcomeDriver get() {
        return new ActionOutcomeDriver(new MainScreen(null){});
    }

    public void addActions() {
        final JCheckBoxOperator operator = this.checkBoxNamed(SWITCH_ACTION);
        if (operator.isSelected()) {
            throw new ActionAlreadyToggled(operator.isSelected(), true);
        }
        operator.pushNoBlock();
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return operator.isSelected();
            }
        }, (int)10, (TimeUnit)TimeUnit.SECONDS);
    }

    public void removeActions() {
        final JCheckBoxOperator operator = this.checkBoxNamed(SWITCH_ACTION);
        if (!operator.isSelected()) {
            throw new ActionAlreadyToggled(!operator.isSelected(), false);
        }
        operator.pushNoBlock();
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !operator.isSelected();
            }
        }, (int)10, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean isActionSelected() {
        return this.checkBoxNamed(SWITCH_ACTION).isSelected();
    }

    public String getActionLabel() {
        return this.checkBoxNamed(SWITCH_ACTION).getText();
    }

    public void setTimeout(int seconds) {
        new NumberKeyPadOperator(this.textFieldNamed(TIMEOUT)).punchInKeypad(String.valueOf(seconds));
    }

    public void waitForGripDetection() {
        this.componentNamed(SUCCESS_CARD);
    }
}

