/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.swing.driver;

import com.ur.polyscope.application.driver.conceptoperations.ApplicationPersistenceDriver;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.Dialog;
import com.ur.polyscope.driver.api.dialog.DialogDriverFactory;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;

public class PolyScopeDriver
extends BaseDriver {
    public static final String GRIP_OR_RELEASE_DETECTED_NODE = "detected";
    public static final String TIMEOUT_NODE = "timeout";
    private static final String INSTALLATION_SCREEN = "installationScreen.HeaderMenu";
    private static final String PROGRAM_SCREEN = "programScreen.HeaderMenu";
    private static final String URCAPS_TAB = "urCapsTab.G5URCapInstallationHeaderMenuExtension";
    public static final String PROGRAM_URCAPS_TAB = "uRCapsNodesSection.ProgramTab";
    public static final String ADVANCED_NODES_SECTION = "advancedNodesSection.ProgramTab";
    public static final String TEMPLATES_TAB = "wizardNodesSection.ProgramTab";
    private static final String OPEN_TOOLBAR = "urcapToolbar.ToolbarGlassPanelOverlayAction";
    private static final String PROGRAM_TREE = "programTree.ProgramPanel";
    @Inject
    ApplicationPersistenceDriver persistenceDriver;

    @Inject
    PolyScopeDriver(MainScreen mainScreen) {
        super(mainScreen, "gripper.driver");
    }

    private void goTo(String screen) {
        this.push(this.buttonNamed(screen));
        Waiting.pause((long)3L, (TimeUnit)TimeUnit.SECONDS);
    }

    public void saveProgram(String programName) {
        this.persistenceDriver.saveProgramHeader(programName);
    }

    public void saveInstallation(String installationName) {
        this.persistenceDriver.saveInstallationHeader(installationName);
    }

    public void loadProgram(String programName) {
        this.persistenceDriver.loadProgramHeader(programName);
    }

    public void waitUntilProgramIsLoaded(String programName) {
        Waiting.until(() -> this.persistenceDriver.programLoaded(programName), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public void loadInstallation(String installationName) {
        this.persistenceDriver.loadInstallationHeader(installationName);
    }

    public void confirmUpdateInstallation() {
        if (DialogDriverFactory.isDialogShown((Dialog)DialogWithName.SET_INSTALLATION_FOR_PROGRAM)) {
            DialogDriverFactory.createDriver((Dialog)DialogWithName.SET_INSTALLATION_FOR_PROGRAM).pushButton("confirm.confirmMessageDialog");
        }
    }

    public void confirmSafetyPopup() {
        if (DialogDriverFactory.isDialogShown((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION)) {
            DialogDriverFactory.createDriver((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION).pushButton("rightArrowKey.MessageDialogPanel");
        }
        if (DialogDriverFactory.isDialogShown((Dialog)DialogWithName.CONFIRM_SAFETY_CONFIGURATION)) {
            DialogDriverFactory.createDriver((Dialog)DialogWithName.CONFIRM_SAFETY_CONFIGURATION).pushButton("confirm.confirmMessageDialog");
        }
    }

    public void goToInstallationScreen() {
        this.goTo(INSTALLATION_SCREEN);
    }

    public void goToURCapsTab() {
        this.goTo(URCAPS_TAB);
    }

    public boolean hasButtonNamed(String name) {
        return this.buttonNamed(name) != null;
    }

    public boolean hasTabLabel(String name) {
        return this.labelNamed(name) != null;
    }

    public void goToProgramScreen() {
        this.goTo(PROGRAM_SCREEN);
    }

    public void goToAdvancedTab() {
        this.goTo(ADVANCED_NODES_SECTION);
    }

    public void goToTemplatesTab() {
        this.goTo(TEMPLATES_TAB);
    }

    public void toggleToolbar() {
        this.goTo(OPEN_TOOLBAR);
    }

    public void createAdvancedNode(String name) {
        this.goTo(name);
    }

    public void createNode(String title) {
        this.goTo("wizardNodesSection.ProgramTab." + title);
    }

    public void goToProgramURCapsTab() {
        this.goTo(PROGRAM_URCAPS_TAB);
    }

    public void inputExpression(String expr) {
        this.textFieldNamed("expressionField.com.ur.program.nodes.assignment.AssignmentCard").clickMouse();
        JTextFieldOperator expressionEditorJTextField = this.textFieldNamed("TEXT_PICKER.ExpressionPicker", "expressionTextField.ExpressionEditorPanel");
        expressionEditorJTextField.typeText(expr);
        this.push(this.buttonNamed("TEXT_PICKER.ExpressionPicker", "OK.ExpressionPicker"));
    }

    public void navigateToTreeNode(String text) {
        if (!Waiting.until(() -> this.treeHasNode(text), (int)5, (TimeUnit)TimeUnit.SECONDS)) {
            throw new IllegalStateException("Unable to navigate to tree node named: " + text);
        }
        this.push(this.itemMatching(text, this.treeNamed(PROGRAM_TREE)));
    }

    public boolean treeHasNode(String text) {
        JTreeOperator tree = this.treeNamed(PROGRAM_TREE);
        return tree.findRow(text) >= 0;
    }

    public void navigateToTreeNodeWithIndex(int nodeIndex) {
        this.treeNamed(PROGRAM_TREE).selectRow(nodeIndex);
    }

    public void navigateToRobotProgramNode() {
        this.navigateToTreeNodeWithIndex(1);
    }
}

