/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.swing.driver;

import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.gripper.swing.driver.AbstractIntegrationSupportDriver;
import com.ur.polyscope.gripper.swing.driver.NodeNotFound;
import com.ur.polyscope.payload.common.PayloadSelection;
import com.ur.swing.number.NumberField;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.util.Waiting;
import java.awt.Dimension;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JSliderOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;

public class ProgramNodeGripperDriver
extends AbstractIntegrationSupportDriver {
    public static final String WIDTH_NUMBER_FIELD = "numberFieldWidth.ProgramNodeView";
    public static final String FORCE_NUMBER_FIELD = "numberFieldForce.ProgramNodeView";
    public static final String VACUUM_NUMBER_FIELD = "numberFieldVacuum.ProgramNodeView";
    public static final String SPEED_NUMBER_FIELD = "numberFieldSpeed.ProgramNodeView";
    public static final String RELEASE_RADIO_BUTTON_PROGRAM_NODE_VIEW = "ReleaseRadioButton.ProgramNodeView";
    public static final String GRIP_RADIO_BUTTON_PROGRAM_NODE_VIEW = "GripRadioButton.ProgramNodeView";
    public static final String FEEDBACK_DETECTION_TOGGLE_PROGRAM_NODE_VIEW = "feedbackDetectionToggle.ProgramNodeView";
    public static final String SLIDER_WIDTH_PROGRAM_NODE_VIEW = "sliderWidth.ProgramNodeView";
    public static final String SLIDER_FORCE_PROGRAM_NODE_VIEW = "sliderForce.ProgramNodeView";
    public static final String SLIDER_SPEED_PROGRAM_NODE_VIEW = "sliderSpeed.ProgramNodeView";
    public static final String SLIDER_VACUUM_PROGRAM_NODE_VIEW = "sliderVacuum.ProgramNodeView";
    public static final String MULTI_GRIPPER_COMBOBOX = "MultiGripperSelectionPanel.ComboBox";
    public static final String UNDEFINED_WARNING = "undefinedWarning";
    public static final String PAYLOAD_PANEL_USE_PAYLOAD = "PayloadPanel.UsePayload";
    private static final String PAYLOAD_PANEL_COMBOBOX = "PayloadPanel.ComboBox";
    private static final String PAYLOAD_WARNING_NAME = "payloadWarning";
    private static final String PAYLOAD_PANEL_MASS = "PayloadPanel.Mass";

    @Inject
    public ProgramNodeGripperDriver(MainScreen mainScreen) {
        super(mainScreen, "programNode-gripper-driver");
    }

    public static ProgramNodeGripperDriver get(JComponent component, Dimension dimensions) {
        AbstractIntegrationSupportDriver.launchInFrame(component, dimensions);
        return new ProgramNodeGripperDriver(new MainScreen(null){});
    }

    public String getWidth() {
        return this.textFieldNamed(WIDTH_NUMBER_FIELD).getText();
    }

    public void setWidth(String value) {
        JTextFieldOperator fieldName = this.textFieldNamed(WIDTH_NUMBER_FIELD);
        this.punchInKeyPad(fieldName, value);
    }

    private void punchInKeyPad(JTextFieldOperator textFieldNamed, String text) {
        new NumberKeyPadOperator(textFieldNamed).punchInKeypad(text);
    }

    public void setMaxWidth() {
        this.setMax(SLIDER_WIDTH_PROGRAM_NODE_VIEW);
    }

    public void setMinWidth() {
        this.setMin(SLIDER_WIDTH_PROGRAM_NODE_VIEW);
    }

    public String getForce() {
        return this.textFieldNamed(FORCE_NUMBER_FIELD).getText();
    }

    public void setForce(String s) {
        this.punchInKeyPad(this.textFieldNamed(FORCE_NUMBER_FIELD), s);
    }

    public void setMaxForce() {
        this.setMax(SLIDER_FORCE_PROGRAM_NODE_VIEW);
    }

    public void setMinForce() {
        this.setMin(SLIDER_FORCE_PROGRAM_NODE_VIEW);
    }

    public String getSpeed() {
        return this.textFieldNamed(SPEED_NUMBER_FIELD).getText();
    }

    public void setSpeed(String s) {
        this.punchInKeyPad(this.textFieldNamed(SPEED_NUMBER_FIELD), s);
    }

    public void setMaxSpeed() {
        this.setMax(SLIDER_SPEED_PROGRAM_NODE_VIEW);
    }

    public void setMinSpeed() {
        this.setMin(SLIDER_SPEED_PROGRAM_NODE_VIEW);
    }

    public String getVacuum() {
        return this.textFieldNamed(VACUUM_NUMBER_FIELD).getText();
    }

    public void setVacuum(String s) {
        this.punchInKeyPad(this.textFieldNamed(VACUUM_NUMBER_FIELD), s);
    }

    public void setMaxVacuum() {
        this.setMax(SLIDER_VACUUM_PROGRAM_NODE_VIEW);
    }

    public void setMinVacuum() {
        this.setMin(SLIDER_VACUUM_PROGRAM_NODE_VIEW);
    }

    private void setMin(String sliderName) {
        JSliderOperator slider = this.sliderNamed(sliderName);
        slider.setValue(slider.getMinimum());
    }

    private void setMax(String sliderName) {
        JSliderOperator slider = this.sliderNamed(sliderName);
        slider.setValue(slider.getMaximum());
    }

    public boolean isGrip() {
        return this.radioButtonNamed(GRIP_RADIO_BUTTON_PROGRAM_NODE_VIEW).isSelected() && !this.radioButtonNamed(RELEASE_RADIO_BUTTON_PROGRAM_NODE_VIEW).isSelected();
    }

    public boolean isOperationDefined() {
        return this.radioButtonNamed(GRIP_RADIO_BUTTON_PROGRAM_NODE_VIEW).isSelected() || this.radioButtonNamed(RELEASE_RADIO_BUTTON_PROGRAM_NODE_VIEW).isSelected();
    }

    public void selectGrip() {
        this.radioButtonNamed(GRIP_RADIO_BUTTON_PROGRAM_NODE_VIEW).doClick(50);
    }

    public void selectGripper(String gripperToString) {
        if (!this.selectItemInComboBox(gripperToString, this.comboBoxNamed(MULTI_GRIPPER_COMBOBOX))) {
            throw new AssertionError((Object)"Failed to select item");
        }
    }

    public Object getGripperSelection() {
        JComboBoxOperator jComboBoxOperator = this.comboBoxNamed(MULTI_GRIPPER_COMBOBOX);
        return jComboBoxOperator.getSelectedItem();
    }

    private boolean selectItemInComboBox(String elementString, JComboBoxOperator comboBoxNamed) {
        for (int i = 0; i < comboBoxNamed.getModel().getSize(); ++i) {
            Object element = comboBoxNamed.getModel().getElementAt(i);
            if (!element.toString().equals(elementString)) continue;
            comboBoxNamed.getModel().setSelectedItem(element);
            return Waiting.until((Waiting.ItHappens)new IndexSelected(comboBoxNamed, i), (int)5, (TimeUnit)TimeUnit.SECONDS);
        }
        return false;
    }

    public void selectRelease() {
        this.radioButtonNamed(RELEASE_RADIO_BUTTON_PROGRAM_NODE_VIEW).doClick(50);
    }

    public void setReleaseSelected() {
        this.radioButtonNamed(GRIP_RADIO_BUTTON_PROGRAM_NODE_VIEW).setSelected(false);
        this.radioButtonNamed(RELEASE_RADIO_BUTTON_PROGRAM_NODE_VIEW).setSelected(true);
    }

    public void performTest() {
        this.buttonNamed("testParameters.ProgramNodeView").clickMouse();
    }

    public boolean isAddActionVisible() {
        return this.checkBoxNamed(FEEDBACK_DETECTION_TOGGLE_PROGRAM_NODE_VIEW).isVisible();
    }

    public boolean isAddActionOn() {
        return this.checkBoxNamed(FEEDBACK_DETECTION_TOGGLE_PROGRAM_NODE_VIEW).isSelected();
    }

    public void toggleAddAction() {
        this.buttonNamed(FEEDBACK_DETECTION_TOGGLE_PROGRAM_NODE_VIEW).push();
    }

    public Object[] getSubtreeOfSelectedNode() {
        JTreeOperator programTree = this.treeNamed("programTree.ProgramPanel");
        Object selected = programTree.getLastSelectedPathComponent();
        return programTree.getChildren(selected);
    }

    public void select(String nodeWithName) {
        JTreeOperator treeOperator = this.treeNamed("programTree.ProgramPanel");
        this.printLine(" Trying to select '" + nodeWithName + "'");
        if (!Waiting.until(() -> {
            for (int i = 0; i < treeOperator.getRowCount(); ++i) {
                TreePath path = treeOperator.getPathForRow(i);
                if (!path.getLastPathComponent().toString().toLowerCase().contains(nodeWithName.toLowerCase())) continue;
                treeOperator.clickOnPath(path);
                return true;
            }
            return false;
        }, (int)60, (int)2, (TimeUnit)TimeUnit.SECONDS)) {
            throw new NodeNotFound(nodeWithName);
        }
    }

    public boolean hasChildren() {
        return Waiting.until(() -> {
            Object[] subtree = this.getSubtreeOfSelectedNode();
            return subtree.length > 0;
        }, (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean hasNoChildren() {
        return Waiting.until(() -> {
            Object[] subtree = this.getSubtreeOfSelectedNode();
            return subtree.length == 0;
        }, (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean isWidthSliderEnabled() {
        JSliderOperator slider = this.sliderNamed(SLIDER_WIDTH_PROGRAM_NODE_VIEW);
        return slider.isEnabled();
    }

    public boolean isSpeedSliderEnabled() {
        JSliderOperator slider = this.sliderNamed(SLIDER_SPEED_PROGRAM_NODE_VIEW);
        return slider.isEnabled();
    }

    public boolean isForceSliderEnabled() {
        JSliderOperator slider = this.sliderNamed(SLIDER_FORCE_PROGRAM_NODE_VIEW);
        return slider.isEnabled();
    }

    public boolean isVacuumSliderEnabled() {
        JSliderOperator slider = this.sliderNamed(SLIDER_VACUUM_PROGRAM_NODE_VIEW);
        return slider.isEnabled();
    }

    public boolean showingAllGrippersDisabled() {
        return this.labelNamed("noGrippersAvailable.toolbar").isVisible();
    }

    public boolean showingUndefinedWarning() {
        return Waiting.until(() -> {
            JLabelOperator label = this.labelNamed(UNDEFINED_WARNING);
            return label.getText().contains("installation is incomplete");
        }, (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean noWarningMessage() {
        return Waiting.until(() -> this.isNotShowing(UNDEFINED_WARNING), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public void setEnablePayload(boolean b) {
        this.getUsePayloadCheckBox().setSelected(b);
    }

    private JCheckBoxOperator getUsePayloadCheckBox() {
        return this.checkBoxNamed(PAYLOAD_PANEL_USE_PAYLOAD);
    }

    public void selectCustomGripPayload() {
        JComboBoxOperator operator = this.getGripPayloadSelection();
        this.selectCustomPayload(operator);
    }

    private void selectCustomPayload(JComboBoxOperator operator) {
        for (int i = 0; i < operator.getItemCount(); ++i) {
            Object item = operator.getItemAt(i);
            if (!(item instanceof PayloadSelection) || ((PayloadSelection)item).getPayloadSelectionType() != PayloadSelection.SelectionType.CUSTOM_MASS) continue;
            operator.setSelectedItem(item);
            return;
        }
    }

    public void selectPayloadForGripAction(String payloadName) {
        JComboBoxOperator operator = this.getGripPayloadSelection();
        this.selectItemInComboBox(payloadName, operator);
    }

    public void setPayload(String text) {
        JTextFieldOperator payloadField = this.getPayloadMassField();
        NumberKeyPadOperator operator = new NumberKeyPadOperator(payloadField);
        operator.clickClear();
        operator.punchInKeypad(text);
    }

    private JComboBoxOperator getGripPayloadSelection() {
        return this.comboBoxNamed(PAYLOAD_PANEL_COMBOBOX);
    }

    private JTextFieldOperator getPayloadMassField() {
        return this.textFieldNamed(PAYLOAD_PANEL_MASS);
    }

    public boolean numberFieldHasWarning() {
        JTextFieldOperator payloadField = this.getPayloadMassField();
        if (payloadField.getSource() instanceof NumberField) {
            NumberField numberField = (NumberField)payloadField.getSource();
            return Waiting.until(() -> numberField.hasWarning(), (int)3, (TimeUnit)TimeUnit.SECONDS);
        }
        return false;
    }

    public boolean numberFieldHasError() {
        JTextFieldOperator payloadField = this.getPayloadMassField();
        if (payloadField.getSource() instanceof NumberField) {
            NumberField numberField = (NumberField)payloadField.getSource();
            return Waiting.until(() -> numberField.hasError(), (int)3, (TimeUnit)TimeUnit.SECONDS);
        }
        return false;
    }

    public boolean hasRatedPayloadWarning() {
        return this.hasWarningOrErrorMessageAs("Rated payload of 5.000 kg exceeded");
    }

    public boolean hasRememberPayloadWarning() {
        return this.hasWarningOrErrorMessageAs("Remember to set the total payload mass");
    }

    public boolean hasErrorInInstallationPayloadMsg() {
        return this.hasWarningOrErrorMessageAs("The payload has an error in the installation");
    }

    public boolean hasPayloadCogComboAffectPerformanceWarning() {
        return this.hasWarningOrErrorMessageAs("The current combination of payload and CoG may affect robot performance");
    }

    private boolean hasWarningOrErrorMessageAs(String message) {
        return Waiting.until(() -> {
            JLabelOperator label = this.labelNamed(PAYLOAD_WARNING_NAME);
            return label.getText().contains(message);
        }, (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public String getPayloadMassValue() {
        return this.getPayloadMassField().getText();
    }

    private static class IndexSelected
    implements Waiting.ItHappens {
        private final JComboBoxOperator comboBoxNamed;
        private final int selectedIndex;

        public IndexSelected(JComboBoxOperator comboBoxNamed, int selectedIndex) {
            this.comboBoxNamed = comboBoxNamed;
            this.selectedIndex = selectedIndex;
        }

        public boolean itHappened() {
            return this.comboBoxNamed.getSelectedIndex() == this.selectedIndex;
        }
    }
}

