/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.swing.driver;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class SuccessCardDriver
extends BaseDriver {
    private static final String PAYLOAD_FILED = "payloadInputField.SuccessCard";
    public static final String PAYLOAD_ENABLED_CHECKBOX = "payloadEnabledCheckbox.SuccessCard";

    public SuccessCardDriver(MainScreen mainScreen) {
        super(mainScreen, "success-card-driver");
    }

    public static SuccessCardDriver create() {
        return new SuccessCardDriver(new MainScreen(null){});
    }

    public void setPayloadEnabled(boolean enabled) {
        JCheckBoxOperator checkbox = this.checkBoxNamed(PAYLOAD_ENABLED_CHECKBOX);
        if (checkbox.isSelected() != enabled) {
            checkbox.push();
        }
    }

    public boolean isPayloadEnabled() {
        JCheckBoxOperator checkbox = this.checkBoxNamed(PAYLOAD_ENABLED_CHECKBOX);
        return checkbox.isSelected();
    }

    public boolean isPayloadInputFieldEnabled() {
        return this.textFieldNamed(PAYLOAD_FILED).isEnabled();
    }

    public void enterPayload(String value) {
        JTextFieldOperator textField = this.textFieldNamed(PAYLOAD_FILED);
        this.punchInKeyPad(textField, value);
        this.waitForFieldToContainText(value, textField);
    }

    private void waitForFieldToContainText(final String newTimeout, final JTextFieldOperator timeout) {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return timeout.getText().contains(newTimeout);
            }
        }, (int)1, (TimeUnit)TimeUnit.MINUTES);
    }

    private void punchInKeyPad(JTextFieldOperator textFieldNamed, String text) {
        NumberKeyPadOperator numberKeyPadOperator = new NumberKeyPadOperator(textFieldNamed);
        if (text.isEmpty()) {
            numberKeyPadOperator.clickClear();
            numberKeyPadOperator.clickOk();
        } else {
            numberKeyPadOperator.punchInKeypad(text);
        }
    }
}

