/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.swing.driver;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.valueobjects.Time;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class TimeoutOutcomeDriver
extends BaseDriver {
    public TimeoutOutcomeDriver(MainScreen mainScreen) {
        super(mainScreen, "programNode-timeout-outcome-driver");
    }

    public static TimeoutOutcomeDriver get() {
        return new TimeoutOutcomeDriver(new MainScreen(null){});
    }

    public Time getTimeout() {
        String value = this.getTimeoutField().getText();
        return Time.from((double)Double.parseDouble(value), (Time.Unit)Time.Unit.SECONDS);
    }

    public void enterTimeout(String newTimeout) {
        JTextFieldOperator timeout = this.getTimeoutField();
        this.punchInKeyPad(timeout, newTimeout);
        this.waitForFieldToContainText(newTimeout, timeout);
    }

    private void punchInKeyPad(JTextFieldOperator timoutField, String text) {
        new NumberKeyPadOperator(timoutField).punchInKeypad(text);
    }

    private void waitForFieldToContainText(final String newTimeout, final JTextFieldOperator timeout) {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return timeout.getText().contains(newTimeout);
            }
        }, (int)1, (TimeUnit)TimeUnit.MINUTES);
    }

    public void tryEnterTimeout(String text) {
        String original = this.getTimeoutField().getText();
        this.getTimeoutField().setText(text);
        if (!Waiting.until((Waiting.ItHappens)new WaitForErrorState(), (int)10, (TimeUnit)TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Failed to make background red");
        }
        this.getTimeoutField().setText(original);
    }

    private JTextFieldOperator getTimeoutField() {
        return this.textFieldNamed("timeout.TimeoutCard");
    }

    private class WaitForErrorState
    implements Waiting.ItHappens {
        private WaitForErrorState() {
        }

        public boolean itHappened() {
            return TimeoutOutcomeDriver.this.getTimeoutField().getBackground() == DisplayMessageFactory.ERROR_COLOR;
        }
    }
}

