/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.swing.driver;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.payload.common.PayloadSelection;
import com.ur.swing.number.NumberField;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class ToolbarGripperDriver
extends BaseDriver {
    private static final String GRIP_PAYLOAD_PANEL_USE_PAYLOAD = "grip.PayloadPanel.UsePayload";
    private static final String GRIP_PAYLOAD_PANEL_SELECTION = "grip.PayloadPanel.Selection";
    private static final String GRIP_PAYLOAD_PANEL_MASS = "grip.PayloadPanel.Mass";
    private static final String RELEASE_PAYLOAD_PANEL_USE_PAYLOAD = "release.PayloadPanel.UsePayload";
    private static final String RELEASE_PAYLOAD_PANEL_SELECTION = "release.PayloadPanel.Selection";
    private static final String RELEASE_PAYLOAD_PANEL_MASS = "release.PayloadPanel.Mass";

    public static ToolbarGripperDriver get() {
        return new ToolbarGripperDriver(new MainScreen(null){});
    }

    @Inject
    protected ToolbarGripperDriver(MainScreen mainScreen) {
        super(mainScreen, "toolbar.gripper.driver");
    }

    public void performGripAction() {
        this.buttonNamed("performGripAction.toolbar").clickMouse();
    }

    public void performReleaseAction() {
        this.push(this.buttonNamed("performReleaseAction.toolbar"));
    }

    public String selectedGripperDisplayText() {
        return this.comboBoxNamed("selectGripper.toolbar").getSelectedItem() + "";
    }

    public boolean noGrippersMessageShowing() {
        JLabelOperator message = this.labelNamed("noGrippersAvailable.toolbar");
        return message.isVisible();
    }

    public void setEnableGripPayload(boolean b) {
        this.getGripUsePayloadCheckBox().setSelected(b);
    }

    public void selectCustomGripPayload() {
        JComboBoxOperator operator = this.getGripPayloadSelection();
        this.selectCustomPayload(operator);
    }

    private void selectCustomPayload(JComboBoxOperator operator) {
        for (int i = 0; i < operator.getItemCount(); ++i) {
            Object item = operator.getItemAt(i);
            if (!(item instanceof PayloadSelection) || ((PayloadSelection)item).getPayloadSelectionType() != PayloadSelection.SelectionType.CUSTOM_MASS) continue;
            operator.setSelectedItem(item);
            return;
        }
    }

    public void setEnableReleasePayload(boolean b) {
        this.getReleaseUsePayloadCheckBox().setSelected(b);
    }

    public void selectCustomReleasePayload() {
        JComboBoxOperator operator = this.getReleasePayloadSelection();
        this.selectCustomPayload(operator);
    }

    public void setPayload(String text, Operation operation) {
        JTextFieldOperator payloadField = operation == Operation.GRIP ? this.getGripPayloadMassField() : this.getReleasePayloadMassField();
        NumberKeyPadOperator operator = new NumberKeyPadOperator(payloadField);
        operator.clickClear();
        operator.punchInKeypad(text);
    }

    public String getPayloadMassValue(Operation operation) {
        JTextFieldOperator payloadField = operation == Operation.GRIP ? this.getGripPayloadMassField() : this.getReleasePayloadMassField();
        return payloadField.getText();
    }

    public void tryTypePayload(String text, Operation operation) {
        JTextFieldOperator payloadField = operation == Operation.GRIP ? this.getGripPayloadMassField() : this.getReleasePayloadMassField();
        NumberKeyPadOperator operator = new NumberKeyPadOperator(payloadField);
        operator.clickClear();
        operator.typeFullText(text);
    }

    public boolean hasWarning(Operation operation) {
        JTextFieldOperator payloadField;
        JTextFieldOperator jTextFieldOperator = payloadField = operation == Operation.GRIP ? this.getGripPayloadMassField() : this.getReleasePayloadMassField();
        if (payloadField.getSource() instanceof NumberField) {
            final NumberField numberField = (NumberField)payloadField.getSource();
            return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                public boolean itHappened() {
                    return numberField.hasWarning();
                }
            }, (int)3, (TimeUnit)TimeUnit.SECONDS);
        }
        return false;
    }

    public boolean hasError(Operation operation) {
        JTextFieldOperator payloadField;
        JTextFieldOperator jTextFieldOperator = payloadField = operation == Operation.GRIP ? this.getGripPayloadMassField() : this.getReleasePayloadMassField();
        if (payloadField.getSource() instanceof NumberField) {
            final NumberField numberField = (NumberField)payloadField.getSource();
            return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                public boolean itHappened() {
                    return numberField.hasError();
                }
            }, (int)3, (TimeUnit)TimeUnit.SECONDS);
        }
        return false;
    }

    private JCheckBoxOperator getGripUsePayloadCheckBox() {
        return this.checkBoxNamed(GRIP_PAYLOAD_PANEL_USE_PAYLOAD);
    }

    private JComboBoxOperator getGripPayloadSelection() {
        return this.comboBoxNamed(GRIP_PAYLOAD_PANEL_SELECTION);
    }

    private JTextFieldOperator getGripPayloadMassField() {
        return this.textFieldNamed(GRIP_PAYLOAD_PANEL_MASS);
    }

    private JCheckBoxOperator getReleaseUsePayloadCheckBox() {
        return this.checkBoxNamed(RELEASE_PAYLOAD_PANEL_USE_PAYLOAD);
    }

    private JComboBoxOperator getReleasePayloadSelection() {
        return this.comboBoxNamed(RELEASE_PAYLOAD_PANEL_SELECTION);
    }

    private JTextFieldOperator getReleasePayloadMassField() {
        return this.textFieldNamed(RELEASE_PAYLOAD_PANEL_MASS);
    }

    public boolean isOKButtonDisabledOnKeypad(Operation operation) {
        JTextFieldOperator payloadField = operation == Operation.GRIP ? this.getGripPayloadMassField() : this.getReleasePayloadMassField();
        final NumberKeyPadOperator operator = new NumberKeyPadOperator(payloadField);
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !operator.isOkButtonEnabled();
            }
        }, (int)3, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean isReleaseActionButtonEnabled() {
        return this.buttonNamed("performReleaseAction.toolbar").isEnabled();
    }

    public boolean isGripActionButtonEnabled() {
        return this.buttonNamed("performGripAction.toolbar").isEnabled();
    }

    public boolean actionsAreDisabled() {
        return Waiting.until((Waiting.ItHappens)this.isDisabled((JComponentOperator)this.buttonNamed("performGripAction.toolbar")), (int)5, (TimeUnit)TimeUnit.SECONDS) && Waiting.until((Waiting.ItHappens)this.isDisabled((JComponentOperator)this.buttonNamed("performReleaseAction.toolbar")), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public void selectPayload(String payloadName, Operation operation) {
        JComboBoxOperator operator = operation == Operation.GRIP ? this.getGripPayloadSelection() : this.getReleasePayloadSelection();
        this.selectItemInComboBox(payloadName, operator);
    }

    private boolean selectItemInComboBox(String elementString, JComboBoxOperator comboBoxNamed) {
        for (int i = 0; i < comboBoxNamed.getModel().getSize(); ++i) {
            Object element = comboBoxNamed.getModel().getElementAt(i);
            if (!element.toString().equals(elementString)) continue;
            comboBoxNamed.getModel().setSelectedItem(element);
            return Waiting.until((Waiting.ItHappens)new IndexSelected(comboBoxNamed, i), (int)5, (TimeUnit)TimeUnit.SECONDS);
        }
        return false;
    }

    public boolean isCustomPayloadSelected(Operation operation) {
        JComboBoxOperator releaseComboBox = operation == Operation.GRIP ? this.getGripPayloadSelection() : this.getReleasePayloadSelection();
        Object item = releaseComboBox.getSelectedItem();
        return item instanceof PayloadSelection && ((PayloadSelection)item).getPayloadSelectionType() == PayloadSelection.SelectionType.CUSTOM_MASS;
    }

    public boolean isNoPayloadSelectedInComboBox(Operation operation) {
        JComboBoxOperator releaseComboBox = operation == Operation.GRIP ? this.getGripPayloadSelection() : this.getReleasePayloadSelection();
        Object item = releaseComboBox.getSelectedItem();
        return item instanceof PayloadSelection && ((PayloadSelection)item).getPayloadSelectionType() == PayloadSelection.SelectionType.UNDEFINED;
    }

    private static class IndexSelected
    implements Waiting.ItHappens {
        private final JComboBoxOperator comboBoxNamed;
        private final int selectedIndex;

        public IndexSelected(JComboBoxOperator comboBoxNamed, int selectedIndex) {
            this.comboBoxNamed = comboBoxNamed;
            this.selectedIndex = selectedIndex;
        }

        public boolean itHappened() {
            return this.comboBoxNamed.getSelectedIndex() == this.selectedIndex;
        }
    }

    public static enum Operation {
        GRIP,
        RELEASE;

    }
}

