/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.canvasbehavior;

import com.ur.polyscope.geomfeature.ToolSpatialFeature;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehavior;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomMouseListener;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.polyscope.visualizer.j3dcomponents.J3DButton;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.j3dcomponents.J3DSlider;
import com.ur.polyscope.visualizer.resources.ImageResource;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ZoomRenderer
implements J3DComponent {
    private final Component component;
    private final ViewBehaviorHolder viewBehaviorHolder;
    private final J3DButton zoomIn;
    private final J3DButton zoomOut;
    private final J3DSlider slider;
    private final int ICON_SIZE = 32;

    public ZoomRenderer(Component component, ViewBehaviorHolder viewBehaviorHolder) {
        this.component = component;
        this.viewBehaviorHolder = viewBehaviorHolder;
        this.zoomIn = new J3DButton(null, ((ImageIcon)this.getZoomInIcon()).getImage(), 32, 32);
        this.zoomIn.setBackground(Color.WHITE);
        this.zoomIn.setBorderColor(Color.BLACK);
        this.zoomIn.addMouseListener(new ZoomMouseListener(viewBehaviorHolder, ViewBehavior.ZOOMING_IN));
        this.zoomOut = new J3DButton(null, ((ImageIcon)this.getZoomOutIcon()).getImage(), 32, 32);
        this.zoomOut.setBackground(Color.WHITE);
        this.zoomOut.setBorderColor(Color.BLACK);
        this.zoomOut.addMouseListener(new ZoomMouseListener(viewBehaviorHolder, ViewBehavior.ZOOMING_OUT));
        this.slider = new J3DSlider();
        this.slider.setBackground(Color.WHITE);
        this.slider.setShowTicks(false);
        this.slider.addPropertyChangeListener(new AdjustZoomChangeListener(viewBehaviorHolder));
    }

    private Icon getZoomInIcon() {
        return ImageResource.gtkAdd();
    }

    private Icon getZoomOutIcon() {
        return ImageResource.gtkRemove();
    }

    @Override
    public void dispatchEvent(AWTEvent e) {
        this.zoomIn.dispatchEvent(e);
        this.zoomOut.dispatchEvent(e);
        this.slider.dispatchEvent(e);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void render(Graphics2D g2d) {
        Dimension dimensions = this.component.getSize();
        int startX = (int)(dimensions.getWidth() - 52.0);
        int startY = (int)((dimensions.getHeight() - 52.0) / 2.0);
        int heightRange = (int)(dimensions.getHeight() / 3.5);
        int totalHeight = heightRange * 2;
        this.zoomIn.setLocation(startX, startY - (heightRange + 32));
        this.zoomIn.render(g2d);
        this.zoomOut.setLocation(startX, startY + heightRange);
        this.zoomOut.render(g2d);
        ViewableGeomFeature joggableGeomFeature = this.viewBehaviorHolder.getJoggableGeomFeature();
        if (joggableGeomFeature != null) {
            double view0 = joggableGeomFeature.getView()[0];
            double distanceFromCamera = joggableGeomFeature instanceof ToolSpatialFeature ? (view0 - 1.0) / 2.0 : (view0 - 0.3) / 4.7;
            this.slider.setValue(distanceFromCamera);
            this.slider.setBounds(startX, startY - heightRange, 32, totalHeight);
            this.slider.render(g2d);
        }
    }

    double getDistanceFromCamera() {
        return this.slider.getValue();
    }

    private static class AdjustZoomChangeListener
    implements PropertyChangeListener {
        private final ViewBehaviorHolder moveTabRobotModel;

        public AdjustZoomChangeListener(ViewBehaviorHolder moveTabRobotModel) {
            this.moveTabRobotModel = moveTabRobotModel;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            double newValue = (Double)propertyChangeEvent.getNewValue();
            double deltaDistanceValue = 0.0;
            double[] view = this.moveTabRobotModel.getJoggableGeomFeature().getView();
            deltaDistanceValue = this.moveTabRobotModel.getJoggableGeomFeature() instanceof ToolSpatialFeature ? view[0] - (newValue * 2.0 + 1.0) : view[0] - (newValue * 4.7 + 0.3);
            this.moveTabRobotModel.getJoggableGeomFeature().moveView(-deltaDistanceValue, 0.0, 0.0);
        }
    }
}

