/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.geomfeature;

import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.GeomFeatureChangedListener;
import com.ur.polyscope.visualizer.geomfeature.JoggableGeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.util.logging.Log;
import java.util.Iterator;
import javax.swing.tree.MutableTreeNode;

public abstract class GeomBranchNode
extends JoggableGeomFeature
implements GeomFeatureChangedListener {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUndefined() {
        if (this.getChildCount() != this.getDesiredChildCount()) return true;
        if (this.arePointsTooClose()) {
            return true;
        }
        try {
            GeomFeature child;
            if (this.children == null) return false;
            Iterator iterator = this.children.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                Object o = iterator.next();
                if (!(o instanceof GeomFeature)) {
                    Log.error((String)("GeomBranchNode.isUndefined(): Something that was not a GeomFeature was in the children array: " + o), (Throwable)new Exception());
                    return true;
                }
                child = (GeomFeature)o;
                child.recalculateTransform();
            } while (!child.isUndefined());
            return true;
        }
        catch (Exception e) {
            Log.error((String)"GeomBranchNode.isUndefined() Error: Failed due to Exception: ", (Throwable)e);
            return true;
        }
    }

    @Override
    public boolean hasHiddenSubFeatureChildren() {
        if (this.children != null) {
            for (Object o : this.children) {
                if (!(o instanceof ViewableGeomFeature) || !((ViewableGeomFeature)o).isHiddenSubFeature()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void insert(MutableTreeNode node, int index) {
        if (node instanceof GeomFeature) {
            if (this.getChildCount() < this.getDesiredChildCount()) {
                super.insert(node, index);
                GeomFeature childToSubscribeTo = (GeomFeature)node;
                childToSubscribeTo.addGeomFeatureChangedListener(this);
            } else {
                Log.error((String)("GeomBranchNode.insert(): Trying to insert a node but no more than " + this.getDesiredChildCount() + " children allowed in class " + this.getClass()));
            }
        }
    }

    @Override
    public void transformHasChanged(GeomFeature geomFeature) {
        this.recalculateTransform();
    }

    public boolean arePointsTooClose() {
        Log.error((String)("GeomBranchNode.arePointsTooClose() Error: Implement this method in subclass: " + this.getClass()));
        return true;
    }

    protected int getDesiredChildCount() {
        Log.error((String)("GeomBranchNode.getDesiredChildCount() Error: Implement this method in subclass: " + this.getClass()));
        return 0;
    }

    protected void recalculateTransformSubClass() {
        Log.error((String)("GeomBranchNode.recalculateTransformSubClass() Error: Implement this method in subclass: " + this.getClass()));
    }

    @Override
    public void recalculateTransform() {
        try {
            if (this.children != null) {
                for (Object o : this.children) {
                    if (o instanceof GeomFeature) {
                        GeomFeature child = (GeomFeature)o;
                        child.recalculateTransform();
                        continue;
                    }
                    Log.error((String)("Something that was not a GeomFeature was in the children array: " + o));
                }
            }
        }
        catch (Exception e) {
            Log.error((String)"Failed due to Exception: ", (Throwable)e);
        }
        this.recalculateTransformSubClass();
    }
}

