/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.geomfeature;

import com.ur.lang.StringUtils;
import com.ur.lang.naming.NameChange;
import com.ur.lang.naming.NameChangeAspect;
import com.ur.lang.naming.NamedEntity;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature$AjcClosure1;
import com.ur.polyscope.visualizer.geomfeature.GeomFeatureChangedListener;
import com.ur.polyscope.visualizer.geomfeature.GeomFeatureObserver;
import com.ur.polyscope.visualizer.geomfeature.ISetupFeatureContainerNode;
import com.ur.polyscope.visualizer.geomfeature.ISetupTreeContainer;
import com.ur.polyscope.visualizer.utils.Pose6dTransformUtils;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.media.j3d.Transform3D;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class GeomFeature
extends DefaultMutableTreeNode
implements NamedEntity,
SpatialFeature {
    protected static final double MAXIMUM_DISTANCE_OF_FEATURE_COORDINATE_TO_BE_CONSIDERED_EQUAL = 0.01;
    private static final boolean LOCK_MUST_BE_FAIR = true;
    protected String name;
    private transient ReentrantLock transformLock;
    private transient Set<GeomFeatureChangedListener> subscriberList = Collections.synchronizedSet(new HashSet());
    private AtomicBoolean ignoreChanges = new AtomicBoolean(false);
    private UUID id = UUID.randomUUID();
    private Transform3D transform = new Transform3D();
    private boolean isVariable = false;
    private boolean persistedIsVariable = false;
    private boolean showAxes = false;
    private Provider<ISetupTreeContainer> setupTreeContainerProvider;
    private boolean hiddenSubFeature;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    public GeomFeature() {
        this.transformLock = new ReentrantLock(true);
    }

    @Inject
    public void setSetupTreeContainerProvider(Provider<ISetupTreeContainer> setupTreeContainerProvider) {
        this.setupTreeContainerProvider = setupTreeContainerProvider;
    }

    public void setHiddenSubFeature(boolean hiddenSubFeature) {
        this.hiddenSubFeature = hiddenSubFeature;
    }

    public boolean isHiddenSubFeature() {
        return this.hiddenSubFeature;
    }

    public boolean hasHiddenSubFeatureChildren() {
        return false;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public abstract void recalculateTransform();

    public void setNewTransform(Transform3D newTransform) {
        this.getLock().lock();
        try {
            this.transform = new Transform3D(newTransform);
        }
        finally {
            this.getLock().unlock();
        }
    }

    private ReentrantLock getLock() {
        if (this.transformLock == null) {
            this.transformLock = new ReentrantLock(true);
        }
        return this.transformLock;
    }

    public void setTransformAccordingToRobotState(Pose6d toolPose) {
    }

    public void copyValuesFromEntity(GeomFeature entityToCopyValuesFrom) {
    }

    @NameChange
    public void setName(String newName) {
        String string = newName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        GeomFeature$AjcClosure1 geomFeature$AjcClosure1 = new GeomFeature$AjcClosure1(objectArray);
        NameChangeAspect.aspectOf().aroundAnnotatedMethod(geomFeature$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.getClass().getName();
    }

    public void makeNewPositionReferences() {
        int i = 0;
        while (i < this.getChildCount()) {
            TreeNode o = this.getChildAt(i);
            if (o instanceof GeomFeature) {
                ((GeomFeature)o).makeNewPositionReferences();
            } else {
                Log.error((String)("There was a '" + (o == null ? null : o.getClass().getName()) + "' child in the " + this.getClass().getName()));
            }
            ++i;
        }
    }

    public Pose6d calculateToolPoseInFeatureCoordinates(Pose6d toolPoseInBaseCoordinates) {
        Transform3D t3dRotated = Pose6dTransformUtils.getTransform3D(toolPoseInBaseCoordinates);
        Pose6d rotatedToolPose = Pose6dTransformUtils.getPose6dEquivalentOfTransform3D(t3dRotated);
        Transform3D t3d = new Transform3D(this.getTransform());
        return Pose6dTransformUtils.getInverseTransformed(rotatedToolPose, t3d);
    }

    public Pose6d transformPoseInFeatureFrameToPoseInBaseFrame(Pose6d poseInFeatureFrame) {
        Pose6d poseInBaseFrame = Pose6dTransformUtils.getTransformed(poseInFeatureFrame, this.getTransform());
        Transform3D t3d = Pose6dTransformUtils.getTransform3D(poseInBaseFrame);
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D(t3d);
    }

    public String getScriptCode() {
        Transform3D t3d = new Transform3D(this.getTransform());
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D(t3d).toString();
    }

    public String getForceModeScriptCode() {
        return this.getScriptCode();
    }

    public void addGeomFeatureChangedListener(GeomFeatureChangedListener subscriber) {
        this.getGeomFeatureChangedListeners().add(subscriber);
        subscriber.transformHasChanged(this);
        if (this.subscriberList.size() > 10) {
            Log.info((String)("GeomFeature.addSubscriber() Warning: There is now " + this.subscriberList.size() + " subscribers "));
            Log.info((String)"Suspect memory leak (forgetting to unsubscribe)");
        }
    }

    public void removeGeomFeatureChangedListener(GeomFeatureChangedListener subscriber) {
        this.getGeomFeatureChangedListeners().remove(subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishTransformChanges() {
        Set<GeomFeatureChangedListener> listeners = this.getGeomFeatureChangedListeners();
        if (!listeners.isEmpty()) {
            Set<GeomFeatureChangedListener> set = listeners;
            synchronized (set) {
                for (GeomFeatureChangedListener gf : listeners) {
                    gf.transformHasChanged(this);
                }
            }
        }
        if (!this.isIgnoreChanges()) {
            EventNotificationService.notify(GeomFeatureChangedListener.class, (NotificationStrategy)new NotificationStrategy<GeomFeatureChangedListener>(){

                public void notify(GeomFeatureChangedListener listener) {
                    listener.transformHasChanged(GeomFeature.this);
                }
            });
        }
    }

    public void removeAllSubscribers() {
        this.getGeomFeatureChangedListeners().clear();
    }

    private synchronized Set<GeomFeatureChangedListener> getGeomFeatureChangedListeners() {
        if (this.subscriberList == null) {
            this.subscriberList = Collections.synchronizedSet(new HashSet());
        }
        return this.subscriberList;
    }

    public Transform3D getTransform() {
        Transform3D transformToReturn = new Transform3D();
        this.getLock().lock();
        try {
            if (this.transform == null) {
                this.transform = new Transform3D();
            }
            transformToReturn.set(this.transform);
        }
        finally {
            this.getLock().unlock();
        }
        return transformToReturn;
    }

    public boolean isUndefined() {
        return true;
    }

    public boolean isDefined() {
        return !this.isUndefined();
    }

    public boolean isJoggableEnabled() {
        return false;
    }

    public void setJoggableEnabled(boolean joggable) {
    }

    public boolean getShowAxes() {
        return this.showAxes;
    }

    public void setShowAxes(boolean showAxes) {
        if (this.showAxes != showAxes) {
            this.showAxes = showAxes;
            if (!this.isIgnoreChanges()) {
                this.notifyInstallationHasChanged();
            }
        }
    }

    protected void notifyInstallationHasChanged() {
        EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener listener) {
                listener.installationModified();
            }
        });
    }

    public Vector3d getTransformPosition() {
        Vector3d position = new Vector3d();
        Transform3D transformLocal = this.getTransform();
        transformLocal.get(position);
        return position;
    }

    public Matrix3d getTransformRotation() {
        Matrix3d rotMat = new Matrix3d();
        Transform3D transformLocal = this.getTransform();
        transformLocal.get(rotMat);
        return rotMat;
    }

    public boolean persistedIsVariable() {
        return this.persistedIsVariable;
    }

    public void setPersistedIsVariable(boolean persistedIsVariable) {
        this.persistedIsVariable = persistedIsVariable;
    }

    public boolean isVariable() {
        return this.isVariable;
    }

    public void setIsVariable(boolean isVariable, boolean checkOtherFeatures) {
        if (this.isVariable == isVariable) {
            return;
        }
        this.isVariable = isVariable;
        this.environmentChange();
        if (!checkOtherFeatures) {
            return;
        }
        for (GeomFeature feature : ((ISetupTreeContainer)this.setupTreeContainerProvider.get()).getFeatureContainerNode().getAllGeomNodes()) {
            if (this == feature || !this.getName().equals(feature.getName()) || !this.sameAs(feature)) continue;
            feature.setIsVariable(isVariable, false);
        }
        EventNotificationService.notify(GeomFeatureObserver.class, (NotificationStrategy)new NotificationStrategy<GeomFeatureObserver>(){

            public void notify(GeomFeatureObserver listener) {
                listener.typeChanged(GeomFeature.this);
            }
        });
    }

    public void environmentChange() {
        this.notifyInstallationHasChanged();
    }

    protected void featureViewNeedsToBeUpdated() {
        if (this.setupTreeContainerProvider == null) {
            return;
        }
        ISetupTreeContainer container = (ISetupTreeContainer)this.setupTreeContainerProvider.get();
        if (container != null) {
            container.getSetupTreeModel().nodeChanged(this);
        }
    }

    public boolean isFirstLevelFeature() {
        boolean isFirstLevelFeature = false;
        if (this.getParent() != null && this.getParent() instanceof ISetupFeatureContainerNode) {
            isFirstLevelFeature = true;
        }
        return isFirstLevelFeature;
    }

    public boolean isIgnoreChanges() {
        return this.ignoreChanges.get();
    }

    public void setIgnoreChanges(boolean ignoreChangesState) {
        this.ignoreChanges.set(ignoreChangesState);
    }

    public boolean getAndSetIgnoreChanges(boolean ignoreChangesState) {
        return this.ignoreChanges.getAndSet(ignoreChangesState);
    }

    public Pose6d getTcpOffset() {
        return null;
    }

    public ToolPosition getSpatialPose() {
        double[] p = this.getPose().toArray();
        return new ToolPosition(p[0], p[1], p[2], p[3], p[4], p[5]);
    }

    private Pose6d getPose() {
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D(this.getTransform());
    }

    static {
        GeomFeature.ajc$preClinit();
    }

    static final /* synthetic */ void setName_aroundBody0(GeomFeature ajc$this, String newName, JoinPoint joinPoint) {
        if (StringUtils.isNullOrOnlyWhitespace((String)newName)) {
            return;
        }
        ajc$this.name = newName;
        ajc$this.environmentChange();
        ajc$this.featureViewNeedsToBeUpdated();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GeomFeature.java", GeomFeature.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setName", "com.ur.polyscope.visualizer.geomfeature.GeomFeature", "java.lang.String", "newName", "", "void"), 107);
    }
}

