/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.geomfeature;

import com.ur.lang.naming.NamedEntity;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.program.nodes.waypoint.VariableWaypointNode;
import com.ur.polyscope.program.variables.Variable;
import com.ur.polyscope.robot.configuration.tool.ToolConfigurationSettings;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import javax.inject.Inject;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public abstract class JoggableGeomFeature
extends ViewableGeomFeature {
    private static final String INKOGNITO = "inkognito";
    private static ToolConfigurationSettings toolConfigurationSettings;
    private boolean joggableEnabled = true;
    private static final double V_TOOL = 0.05;

    @Inject
    public JoggableGeomFeature() {
    }

    @Inject
    public static void setToolConfigurationSettings(ToolConfigurationSettings toolConfigurationSettings) {
        JoggableGeomFeature.toolConfigurationSettings = toolConfigurationSettings;
    }

    @Override
    public boolean isJoggableEnabled() {
        return this.joggableEnabled;
    }

    @Override
    public void setJoggableEnabled(boolean joggable) {
        if (this.joggableEnabled != joggable) {
            this.joggableEnabled = joggable;
            EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

                public void notify(InstallationStateListener listener) {
                    listener.installationModified();
                }
            });
        }
    }

    @Override
    public void appendSpeedJogScriptCode(StringBuffer sb, Vector3d translationSpeed, Vector3d rotationSpeed) {
        Transform3D t3d = this.getTransform();
        Matrix3d m3d = new Matrix3d();
        t3d.get(m3d);
        m3d.transform((Tuple3d)translationSpeed);
        m3d.transform((Tuple3d)rotationSpeed);
        translationSpeed.scale(0.05);
        rotationSpeed.scale(0.05 / toolConfigurationSettings.getEqRadius());
        sb.append("def inkognito():\n");
        sb.append("  speedl([");
        sb.append(translationSpeed.x).append(", ");
        sb.append(translationSpeed.y).append(", ");
        sb.append(translationSpeed.z).append(", ");
        sb.append(rotationSpeed.x).append(", ");
        sb.append(rotationSpeed.y).append(", ");
        sb.append(rotationSpeed.z).append("], ");
        sb.append("0.15, 100.0)\n");
        sb.append("end\n");
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return true;
        }
        if (!this.getName().equals(entityToCompareTo.getName())) {
            return false;
        }
        this.recalculateTransform();
        boolean featureEqualsEntity = false;
        if (entityToCompareTo instanceof GeomFeature) {
            GeomFeature otherFeature = (GeomFeature)entityToCompareTo;
            if (this.getName().equals(otherFeature.getName())) {
                otherFeature.recalculateTransform();
                Transform3D otherTransform = otherFeature.getTransform();
                if (this.getTransform().epsilonEquals(otherTransform, 0.01)) {
                    featureEqualsEntity = true;
                }
            }
        } else if (entityToCompareTo instanceof VariableWaypointNode) {
            if (((VariableWaypointNode)entityToCompareTo).getVariable() != null) {
                featureEqualsEntity = entityToCompareTo.sameAs((NamedEntity)this);
            }
        } else if (entityToCompareTo instanceof Variable) {
            featureEqualsEntity = entityToCompareTo.sameAs((NamedEntity)this);
        }
        return featureEqualsEntity;
    }
}

