/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.geomfeature;

import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.program.nodes.ContributableProgramNode;
import com.ur.polyscope.program.nodes.MainProgramNode;
import com.ur.polyscope.program.nodes.MotionDefiningNode;
import com.ur.polyscope.program.nodes.PatternNode;
import com.ur.polyscope.program.nodes.ProgramNodeTraversal;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.GeomFeatureChangedListener;
import com.ur.polyscope.visualizer.programvisualization.VisualizedProgramNodePositions;
import com.ur.polyscope.visualizer.programvisualization.VisualizerBlend;
import com.ur.polyscope.visualizer.programvisualization.VisualizerMotion;
import com.ur.polyscope.visualizer.programvisualization.VisualizerMotionData;
import com.ur.polyscope.visualizer.programvisualization.VisualizerPositionNode;
import com.ur.polyscope.visualizer.programvisualization.VisualizerProgramRootNode;
import com.ur.polyscope.visualizer.utils.AxesVisualization;
import com.ur.polyscope.visualizer.utils.MaterialDB;
import com.ur.util.ArrayUtils;
import com.ur.util.logging.Log;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public final class ProgramVisualization
implements GeomFeatureChangedListener {
    private static final int MAX_MOTIONS_TO_ADD = 5000;
    private static final int SPHERE_DIVISIONS = 4;
    private final Map<GeomFeature, TransformGroup> coordinateSystemsMap = new HashMap<GeomFeature, TransformGroup>();
    public Map<Shape3D, VisualizerPositionNode> shapeToProgramNodeMap;
    int debugPoint3d;
    int debugPositionNode;
    int debugBlendDefined;
    int debugBlendUndefined;
    private Appearance pathAppearance;
    private Appearance processPathAppearance;
    private Appearance undefinedPathAppearance;
    private Appearance pointsAppearance;
    private Appearance specialPointsAppearance;
    private Appearance obstacleAppearance;
    private Appearance blendAppreance;
    private Appearance singularityPathAppearance;
    private BranchGroup scene;
    private BranchGroup pathsBranchGroup;
    private BranchGroup pointsBranchGroup;
    private BranchGroup obstaclesBranchGroup;
    private BranchGroup geomBranchGroup;
    private BranchGroup coordinateSystemsBranchGroup;
    private boolean isGeomFeaturesAttached;
    private boolean isPathsAttached;
    private boolean isCoordinateSystemsAttached;
    private boolean isPointsAttached;
    private boolean isObstaclesAttached;
    private final boolean isActualCanvas;

    public ProgramVisualization(boolean isActualCanvas) {
        this.isActualCanvas = isActualCanvas;
        if (isActualCanvas) {
            this.pathAppearance = new Appearance();
            this.processPathAppearance = new Appearance();
            this.undefinedPathAppearance = new Appearance();
            this.pointsAppearance = new Appearance();
            this.specialPointsAppearance = new Appearance();
            this.obstacleAppearance = new Appearance();
            this.blendAppreance = new Appearance();
            this.singularityPathAppearance = new Appearance();
            this.scene = new BranchGroup();
            this.scene.setCapability(13);
            this.scene.setCapability(14);
            this.pathsBranchGroup = this.createBranchGroup("PathsGroup");
            this.pointsBranchGroup = this.createBranchGroup("PointsGroup");
            this.geomBranchGroup = this.createBranchGroup("GeomGroup");
            this.coordinateSystemsBranchGroup = this.createBranchGroup("CoordinatesGroup");
            this.obstaclesBranchGroup = this.createObstaclesBranchGroup();
            this.obstacleAppearance.setMaterial(MaterialDB.get(MaterialDB.MaterialID.GREEN_PLASTIC));
            this.obstacleAppearance.setTransparencyAttributes(new TransparencyAttributes(2, 0.4f));
            this.obstacleAppearance.setLineAttributes(new LineAttributes(2.0f, 0, true));
            this.pointsAppearance.setMaterial(MaterialDB.get(MaterialDB.MaterialID.GREEN_RUBBER));
            this.specialPointsAppearance.setMaterial(MaterialDB.get(MaterialDB.MaterialID.RED_PLASTIC));
            this.pathAppearance.setColoringAttributes(new ColoringAttributes(0.0f, 0.0f, 0.0f, 0));
            this.pathAppearance.setLineAttributes(new LineAttributes(2.0f, 0, true));
            this.processPathAppearance.setColoringAttributes(new ColoringAttributes(0.0f, 0.0f, 1.0f, 0));
            this.processPathAppearance.setLineAttributes(new LineAttributes(2.0f, 0, true));
            this.singularityPathAppearance.setColoringAttributes(new ColoringAttributes(0.0f, 0.2f, 0.2f, 0));
            this.singularityPathAppearance.setLineAttributes(new LineAttributes(2.0f, 1, true));
            this.blendAppreance.setColoringAttributes(new ColoringAttributes(0.0f, 0.5f, 0.0f, 0));
            LineAttributes debugLa = new LineAttributes(2.0f, 0, true);
            this.blendAppreance.setLineAttributes(debugLa);
            this.undefinedPathAppearance.setColoringAttributes(new ColoringAttributes(0.2f, 0.2f, 0.2f, 0));
            LineAttributes undefinedPathSysLa = new LineAttributes(2.0f, 2, false);
            undefinedPathSysLa.setPatternMask(43690);
            undefinedPathSysLa.setLinePattern(4);
            this.undefinedPathAppearance.setLineAttributes(undefinedPathSysLa);
            this.shapeToProgramNodeMap = new HashMap<Shape3D, VisualizerPositionNode>();
        }
    }

    public Node getElementNode() {
        return this.scene;
    }

    public void updateProgramVisualization(VisualizerProgramRootNode rootNode, VisualizerMotionData visualizerMotionData) {
        if (rootNode == null) {
            return;
        }
        this.pointsBranchGroup.removeAllChildren();
        this.shapeToProgramNodeMap.clear();
        HashSet<VisualizerPositionNode> pointNodesToDraw = new HashSet<VisualizerPositionNode>();
        this.addPointsGraphics(rootNode, pointNodesToDraw);
        for (VisualizerPositionNode node : pointNodesToDraw) {
            this.addPositionNodeGraphics(node);
        }
        this.updatePathVisualisation(rootNode.getCurrentNode(), visualizerMotionData);
    }

    public Appearance getObstaclesAppearance() {
        return this.obstacleAppearance;
    }

    public void clearVisualization() {
        if (this.isActualCanvas) {
            this.setPointsVisibleState(false);
            this.setPathsVisibleState(false);
            this.setGeomFeaturesVisibleState(false);
            this.setCoordinateSystemsVisibleState(false);
            this.pointsBranchGroup.removeAllChildren();
            this.pathsBranchGroup.removeAllChildren();
            this.geomBranchGroup.removeAllChildren();
            this.coordinateSystemsBranchGroup.removeAllChildren();
            this.shapeToProgramNodeMap.clear();
            for (GeomFeature feature : this.coordinateSystemsMap.keySet()) {
                feature.removeGeomFeatureChangedListener(this);
            }
            this.coordinateSystemsMap.clear();
        }
    }

    public synchronized void updatePathVisualisation(ProgramNodeTraversal node, VisualizerMotionData visualizerMotionData) {
        this.pathsBranchGroup.removeAllChildren();
        HashSet<VisualizerMotion> motionsToAdd = new HashSet<VisualizerMotion>();
        HashSet<VisualizerBlend> blendsToAdd = new HashSet<VisualizerBlend>();
        if (node != null) {
            if (node instanceof ProgramRootNode || node instanceof MainProgramNode) {
                Enumeration en = node.breadthFirstEnumeration();
                while (en.hasMoreElements() && motionsToAdd.size() < 5000) {
                    ProgramNodeTraversal pn = (ProgramNodeTraversal)en.nextElement();
                    if (!(pn instanceof VisualizerPositionNode)) continue;
                    VisualizerPositionNode visualizerPositionNode = (VisualizerPositionNode)pn;
                    motionsToAdd.addAll(visualizerMotionData.getNextMotions(visualizerPositionNode));
                    blendsToAdd.addAll(visualizerMotionData.getBlends(visualizerPositionNode));
                }
            } else if (node instanceof MotionDefiningNode) {
                MotionDefiningNode mdf = (MotionDefiningNode)node;
                Set<? extends VisualizerMotion> ms = visualizerMotionData.getMotions(mdf);
                for (VisualizerMotion visualizerMotion : ms) {
                    motionsToAdd.add(visualizerMotion);
                    Set<? extends VisualizerBlend> blends = visualizerMotionData.getBlends(visualizerMotion.getFromPositionNode());
                    for (VisualizerBlend visualizerBlend : blends) {
                        if (visualizerBlend.toMotion() != visualizerMotion) continue;
                        blendsToAdd.add(visualizerBlend);
                    }
                }
            } else {
                HashSet nodesToVisit = new HashSet();
                nodesToVisit.addAll(node.getThisOrPreviousPositionNodes(VisualizerPositionNode.class));
                HashSet nodesAllreadyVisited = new HashSet();
                while (nodesToVisit.size() > 0 && motionsToAdd.size() < 10) {
                    HashSet hashSet = new HashSet();
                    for (VisualizerPositionNode p : nodesToVisit) {
                        hashSet.addAll(p.getNextPositionNodes(VisualizerPositionNode.class));
                        motionsToAdd.addAll(visualizerMotionData.getNextMotions(p));
                        blendsToAdd.addAll(visualizerMotionData.getBlends(p));
                    }
                    nodesAllreadyVisited.addAll(nodesToVisit);
                    hashSet.removeAll(nodesAllreadyVisited);
                    nodesToVisit = hashSet;
                }
            }
        }
        for (VisualizerMotion m : motionsToAdd) {
            this.addMotionGraphics(m, visualizerMotionData);
        }
        int unusedBlends = 0;
        int blendsWithoutMotions = 0;
        for (VisualizerBlend visualizerBlend : blendsToAdd) {
            if (visualizerBlend == null) continue;
            if (ArrayUtils.isNullOrEmpty((Object[])visualizerBlend.getPathData())) {
                ++unusedBlends;
            }
            if (motionsToAdd.contains(visualizerBlend.fromMotion()) && motionsToAdd.contains(visualizerBlend.toMotion())) {
                this.addBlendGraphics(visualizerBlend);
                continue;
            }
            ++blendsWithoutMotions;
        }
        Log.debug((String)("\n\tMotions to add count: " + motionsToAdd.size() + "\n\tBlends to add count: " + blendsToAdd.size() + "\n\tTotal unused blends: " + unusedBlends + "\n\tTotal blends with motions not in the motionsToAdd: " + blendsWithoutMotions));
        Log.debug((String)String.format("\n\tDraw Motion paths: %s\n\tDraw undefined paths: %s\n\tDraw blends: %s\n\tDraw undefined blends: %s", this.debugPoint3d, this.debugPositionNode, this.debugBlendDefined, this.debugBlendUndefined));
        this.debugBlendUndefined = 0;
        this.debugBlendDefined = 0;
        this.debugPositionNode = 0;
        this.debugPoint3d = 0;
    }

    private void addPositionNodeGraphics(VisualizerPositionNode node) {
        if (node.isUndefined()) {
            return;
        }
        if (node.getPositionNodeType() == PositionNodeType.VARIABLE) {
            return;
        }
        if (node.getPositionNodeType() == PositionNodeType.RELATIVE) {
            return;
        }
        Matrix3d m3d = new Matrix3d();
        m3d.setIdentity();
        Point3d p3d = node.getActualToolPosition();
        Vector3d v3d = new Vector3d(p3d.x, p3d.y, p3d.z);
        Transform3D t3d = new Transform3D(m3d, v3d, 1.0);
        TransformGroup tg = new TransformGroup(t3d);
        Sphere sphere = new Sphere(0.01f, 1, 4, this.pointsAppearance);
        tg.addChild((Node)sphere);
        this.shapeToProgramNodeMap.put(sphere.getShape(), node);
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        bg.addChild((Node)tg);
        this.pointsBranchGroup.addChild((Node)bg);
    }

    private void add3dPointGraphics(Set<Vector3d> v3dset) {
        if (v3dset.size() < 200) {
            for (Vector3d v3d : v3dset) {
                Matrix3d m3d = new Matrix3d();
                m3d.setIdentity();
                Transform3D t3d = new Transform3D(m3d, v3d, 1.0);
                TransformGroup tg = new TransformGroup(t3d);
                Sphere sphere = new Sphere(0.005f, 1, 4, this.specialPointsAppearance);
                tg.addChild((Node)sphere);
                BranchGroup bg = new BranchGroup();
                bg.setCapability(17);
                bg.addChild((Node)tg);
                this.pointsBranchGroup.addChild((Node)bg);
            }
        }
    }

    private void addPatternNodeGraphics(PatternNode node) {
        VisualizedProgramNodePositions visualizedNode = (VisualizedProgramNodePositions)node;
        if (visualizedNode.isUndefined()) {
            return;
        }
        Set<Vector3d> v3dset = visualizedNode.getPositionsToVisualize();
        this.add3dPointGraphics(v3dset);
    }

    private void addVisualizedContributionProgramNodeGraphics(ContributableProgramNode node) {
        VisualizedProgramNodePositions visualizedNode = (VisualizedProgramNodePositions)node;
        if (visualizedNode.isUndefined()) {
            return;
        }
        Set<Vector3d> v3dset = visualizedNode.getPositionsToVisualize();
        this.add3dPointGraphics(v3dset);
    }

    private void addMotionGraphics(VisualizerMotion m, VisualizerMotionData visualizerMotionData) {
        if (m.p3d() != null) {
            if (m.kinematicCheck()) {
                if (m.getToPositionNode().isProcessMoveNode()) {
                    this.addLineStripArray(m.p3d(), this.processPathAppearance);
                } else {
                    this.addLineStripArray(m.p3d(), this.pathAppearance);
                }
            } else {
                this.addLineStripArray(m.p3d(), this.singularityPathAppearance);
            }
            ++this.debugPoint3d;
        } else {
            VisualizerPositionNode fromPos = m.getFromPositionNode();
            VisualizerPositionNode toPos = m.getToPositionNode();
            if (!fromPos.isUndefined() && !toPos.isUndefined() && fromPos.getPositionNodeType() == PositionNodeType.FIXED && toPos.getPositionNodeType() == PositionNodeType.FIXED) {
                boolean drawUndefinedPath;
                block14: {
                    drawUndefinedPath = true;
                    if (toPos.isCircleDefiningNode()) {
                        Set<? extends VisualizerBlend> blends = visualizerMotionData.getBlends(fromPos);
                        for (VisualizerBlend visualizerBlend : blends) {
                            if (ArrayUtils.isNullOrEmpty((Object[])visualizerBlend.getPathData())) continue;
                            drawUndefinedPath = false;
                            break;
                        }
                    } else if (fromPos.isCircleDefiningNode()) {
                        Set previousNodes = fromPos.getPreviousPositionNodes(VisualizerPositionNode.class);
                        for (VisualizerPositionNode visualizerPositionNode : previousNodes) {
                            Set<? extends VisualizerBlend> blends = visualizerMotionData.getBlends(visualizerPositionNode);
                            for (VisualizerBlend visualizerBlend : blends) {
                                if (ArrayUtils.isNullOrEmpty((Object[])visualizerBlend.getPathData())) continue;
                                drawUndefinedPath = false;
                                break block14;
                            }
                        }
                    }
                }
                if (drawUndefinedPath) {
                    ++this.debugPositionNode;
                    Point3d[] points = new Point3d[]{new Point3d(fromPos.getToolPosition()), new Point3d(toPos.getToolPosition())};
                    this.addLineStripArray(points, this.undefinedPathAppearance);
                }
            }
        }
    }

    private void addBlendGraphics(VisualizerBlend b) {
        if (b != null) {
            if (!ArrayUtils.isNullOrEmpty((Object[])b.getPathData())) {
                this.addLineStripArray(b.getPathData(), this.blendAppreance);
                ++this.debugBlendDefined;
            } else if (!b.fromMotion().isUndefined()) {
                if (b.fromMotion().p3d() != null && b.fromMotion().p3d().length > 0) {
                    Point3d[] points = new Point3d[]{new Point3d(b.fromMotion().p3d()[b.fromMotion().p3d().length - 1]), new Point3d(b.fromMotion().getToPositionNode().getToolPosition())};
                    this.addLineStripArray(points, this.undefinedPathAppearance);
                    ++this.debugBlendUndefined;
                }
            } else if (!b.toMotion().isUndefined() && b.toMotion().p3d() != null && b.toMotion().p3d().length > 0) {
                Point3d[] points = new Point3d[]{new Point3d(b.toMotion().getFromPositionNode().getToolPosition()), new Point3d(b.toMotion().p3d()[0])};
                this.addLineStripArray(points, this.undefinedPathAppearance);
                ++this.debugBlendUndefined;
            }
        }
    }

    private void addLineStripArrayToBranchGroup(Point3d[] p3d, Appearance appearance, BranchGroup branchGroupToAddTo) {
        int var = p3d.length;
        if (var < 2) {
            return;
        }
        int[] cpLength = new int[]{var};
        LineStripArray line = new LineStripArray(var, 1, cpLength);
        Shape3D shape = new Shape3D((Geometry)line, appearance);
        int i = 0;
        while (i < p3d.length) {
            line.setCoordinate(i, p3d[i]);
            ++i;
        }
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        bg.addChild((Node)shape);
        branchGroupToAddTo.addChild((Node)bg);
    }

    private void addLineStripArray(Point3d[] p3d, Appearance appearance) {
        this.addLineStripArrayToBranchGroup(p3d, appearance, this.pathsBranchGroup);
    }

    private void addPointsGraphics(ProgramNodeTraversal node, Set<VisualizerPositionNode> pointNodesToDraw) {
        if (node instanceof VisualizerPositionNode) {
            pointNodesToDraw.add((VisualizerPositionNode)node);
        } else if (node instanceof PatternNode) {
            this.addPatternNodeGraphics((PatternNode)node);
        } else if (node instanceof ContributableProgramNode && !((VisualizedProgramNodePositions)node).getPositionsToVisualize().isEmpty()) {
            this.addVisualizedContributionProgramNodeGraphics((ContributableProgramNode)node);
        } else {
            int i = 0;
            while (i < node.getChildCount()) {
                this.addPointsGraphics((ProgramNodeTraversal)node.getChildAt(i), pointNodesToDraw);
                ++i;
            }
        }
    }

    private BranchGroup createBranchGroup(String name) {
        BranchGroup bg = new BranchGroup();
        bg.setName(name);
        bg.setCapability(17);
        bg.setCapability(13);
        bg.setCapability(14);
        return bg;
    }

    public void setPathsVisibleState(boolean newPathsVisibleState) {
        this.isPathsAttached = this.updateSceneGraph(newPathsVisibleState, this.isPathsAttached, this.pathsBranchGroup);
    }

    public void setPointsVisibleState(boolean newPointsVisibleState) {
        this.isPointsAttached = this.updateSceneGraph(newPointsVisibleState, this.isPointsAttached, this.pointsBranchGroup);
    }

    public void setObstaclesVisibleState(boolean newObstaclesVisibleState) {
        this.isObstaclesAttached = this.updateSceneGraph(newObstaclesVisibleState, this.isObstaclesAttached, this.obstaclesBranchGroup);
    }

    public void setGeomFeaturesVisibleState(boolean newGeomFeaturesVisibleState) {
        this.isGeomFeaturesAttached = this.updateSceneGraph(newGeomFeaturesVisibleState, this.isGeomFeaturesAttached, this.geomBranchGroup);
    }

    private boolean updateSceneGraph(boolean isRequestingToAttach, boolean isAttached, BranchGroup branchToModify) {
        if (isRequestingToAttach != isAttached) {
            try {
                if (isRequestingToAttach) {
                    this.scene.addChild((Node)branchToModify);
                } else {
                    this.scene.removeChild((Node)branchToModify);
                }
            }
            catch (Exception e) {
                Log.error((String)("Caught Exception when trying to modify branchgroup: " + branchToModify.getName()), (Throwable)e);
            }
        }
        return isRequestingToAttach;
    }

    private BranchGroup createObstaclesBranchGroup() {
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        double radius = 0.4;
        double height = 0.05;
        Matrix4d m = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 0.0, -height / 2.0, 0.0, 0.0, 0.0, 1.0);
        Cylinder cyl = new Cylinder((float)radius, (float)height, 3, 32, 1, this.obstacleAppearance);
        TransformGroup tg = new TransformGroup(new Transform3D(m));
        tg.addChild((Node)cyl);
        bg.addChild((Node)tg);
        return bg;
    }

    public BranchGroup getGeomBranchGroup() {
        return this.geomBranchGroup;
    }

    public void showTransformCoordinateSystemForFeature(GeomFeature feature) {
        this.showTransformCoordinateSystemForFeature(feature, false, false);
    }

    public void showTransformCoordinateSystemForFeature(GeomFeature feature, boolean transparent, boolean longArrows) {
        if (this.coordinateSystemsMap.containsKey(feature)) {
            TransformGroup tg = this.coordinateSystemsMap.get(feature);
            if (tg != null) {
                Transform3D featuret3d = feature.getTransform();
                tg.setTransform(featuret3d);
            } else {
                Log.error((String)"feature is in map, but transformgroup is null");
            }
        } else {
            TransformGroup tg = AxesVisualization.getElementNode(new Transform3D(feature.getTransform()), transparent, longArrows);
            BranchGroup bg = new BranchGroup();
            bg.setCapability(17);
            bg.addChild((Node)tg);
            this.coordinateSystemsBranchGroup.addChild((Node)bg);
            this.setCoordinateSystemsVisibleState(true);
            this.coordinateSystemsMap.put(feature, tg);
        }
    }

    public void drawPoints(Point3d[] points) {
        this.pointsBranchGroup.removeAllChildren();
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        int i = 0;
        while (i < points.length) {
            Matrix3d m3d = new Matrix3d();
            m3d.setIdentity();
            Transform3D t3d = new Transform3D(m3d, new Vector3d((Tuple3d)points[i]), 1.0);
            TransformGroup tg = new TransformGroup(t3d);
            Sphere sphere = new Sphere(0.005f, this.specialPointsAppearance);
            tg.addChild((Node)sphere);
            bg.addChild((Node)tg);
            ++i;
        }
        this.pointsBranchGroup.addChild((Node)bg);
        this.setPointsVisibleState(true);
    }

    public void setCoordinateSystemsVisibleState(boolean newCoordinateSystemsVisibleState) {
        if (newCoordinateSystemsVisibleState) {
            if (!this.isCoordinateSystemsAttached) {
                try {
                    this.scene.addChild((Node)this.coordinateSystemsBranchGroup);
                }
                catch (Exception e) {
                    Log.error((String)"Caught Exception when trying to add coordinate systems branchgroup: ", (Throwable)e);
                }
            }
        } else if (this.isCoordinateSystemsAttached) {
            try {
                this.coordinateSystemsBranchGroup.removeAllChildren();
                this.coordinateSystemsBranchGroup.detach();
                this.coordinateSystemsMap.clear();
            }
            catch (Exception e) {
                Log.error((String)"Caught Exception when trying to remove coordinate systems branchgroup: ", (Throwable)e);
            }
        }
        this.isCoordinateSystemsAttached = newCoordinateSystemsVisibleState;
    }

    @Override
    public void transformHasChanged(GeomFeature geomFeature) {
        if (geomFeature.getShowAxes() && !geomFeature.isUndefined()) {
            this.showTransformCoordinateSystemForFeature(geomFeature);
        }
    }
}

