/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.geomfeature;

import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.polyscope.visualizer.utils.MaterialDB;
import com.ur.util.logging.Log;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

public abstract class ViewableGeomFeature
extends GeomFeature {
    private static final boolean LOCK_MUST_BE_FAIR = true;
    private static final float DEFAULT_PLANE_TRANSPARENCY = 0.4f;
    private static final float HIGH_PLANE_TRANSPARENCY = 0.7f;
    protected transient ProgramVisualization programVisualization = null;
    private transient Transform3D cameraTransform = new Transform3D();
    private transient UpdateCamera robotCanvas3dViewSubscriber = null;
    private transient ReentrantLock cameraTransformLock = new ReentrantLock(true);
    private transient boolean hasBeenReset = false;
    private float planeTransparency = 0.4f;

    @Inject
    protected ViewableGeomFeature() {
    }

    public abstract void moveView(double var1, double var3, double var5);

    public abstract double[] getView();

    protected void setNewCameraTransform(Transform3D newCameraTransform) {
        this.getCameraTransformLock().lock();
        try {
            this.cameraTransform = new Transform3D(newCameraTransform);
        }
        finally {
            this.getCameraTransformLock().unlock();
        }
    }

    private ReentrantLock getCameraTransformLock() {
        if (this.cameraTransformLock == null) {
            this.cameraTransformLock = new ReentrantLock(true);
        }
        return this.cameraTransformLock;
    }

    public Transform3D getCameraTransform() {
        return this.getCameraTransform(new Transform3D());
    }

    public Transform3D getCameraTransform(Transform3D resultCameraTransform) {
        Transform3D oldCameraTransform;
        if (!this.hasBeenReset) {
            this.hasBeenReset = true;
            this.resetView();
        }
        if ((oldCameraTransform = this.cameraTransform) == null) {
            this.getCameraTransformLock().lock();
            try {
                if (this.cameraTransform == null) {
                    this.recalculateViewTransform();
                }
                oldCameraTransform = this.cameraTransform;
            }
            finally {
                this.getCameraTransformLock().unlock();
            }
        }
        resultCameraTransform.set(oldCameraTransform);
        return resultCameraTransform;
    }

    public abstract void resetView();

    public abstract void recalculateViewTransform();

    protected void publishViewChanges() {
        UpdateCamera rc3dFinal = this.robotCanvas3dViewSubscriber;
        if (rc3dFinal == null) {
            return;
        }
        rc3dFinal.addQueue(new UpdateCameraRunnable(rc3dFinal));
    }

    public void setViewSubscriber(UpdateCamera viewSubscriber) {
        if (this.robotCanvas3dViewSubscriber == viewSubscriber) {
            return;
        }
        this.robotCanvas3dViewSubscriber = viewSubscriber;
        this.publishViewChanges();
    }

    public void setProgramVisualization(ProgramVisualization programVisualisation) {
        Log.error((String)("ViewableGeomFeature.setProgramVisualization() Error: Method not implemented in class = " + this.getClass()));
    }

    public void removeThisReferenceToBeUpdated() {
        this.robotCanvas3dViewSubscriber = null;
    }

    @Override
    public void removeAllSubscribers() {
        super.removeAllSubscribers();
        this.robotCanvas3dViewSubscriber = null;
    }

    public void applyShowAxesChoice(ProgramVisualization programVisualization) {
        this.applyShowAxesChoice(programVisualization, false, false);
    }

    public void applyShowAxesChoice(ProgramVisualization programVisualization, boolean transparent, boolean longArrows) {
        if (this.getShowAxes() && !this.isUndefined()) {
            this.recalculateTransform();
            programVisualization.showTransformCoordinateSystemForFeature(this, transparent, longArrows);
            Log.debug((String)("Adding change listener to " + this.getName()));
            this.addGeomFeatureChangedListener(programVisualization);
        } else {
            programVisualization.setCoordinateSystemsVisibleState(false);
            Log.debug((String)("Removing change listener from " + this.getName()));
            this.removeGeomFeatureChangedListener(programVisualization);
        }
    }

    public void showTransformAxes(ProgramVisualization programVisualization) {
        if (this.getShowAxes() && !this.isUndefined()) {
            this.recalculateTransform();
            programVisualization.showTransformCoordinateSystemForFeature(this);
            this.addGeomFeatureChangedListener(programVisualization);
        }
    }

    protected Appearance getGeomFeatureAppearance() {
        Appearance app = new Appearance();
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setLineWidth(2.0f);
        app.setLineAttributes(lineAttributes);
        Material material = MaterialDB.get(MaterialDB.MaterialID.GREEN_PLASTIC);
        app.setMaterial(material);
        Color3f ambientColor = new Color3f();
        material.getDiffuseColor(ambientColor);
        app.setColoringAttributes(new ColoringAttributes(ambientColor, 0));
        app.setTransparencyAttributes(new TransparencyAttributes(2, this.planeTransparency));
        return app;
    }

    public void setHighPlaneTransparency() {
        this.planeTransparency = 0.7f;
    }

    public void setDefaultPlaneTransparency() {
        this.planeTransparency = 0.4f;
    }

    public abstract void appendSpeedJogScriptCode(StringBuffer var1, Vector3d var2, Vector3d var3);

    public void setOnline(boolean online) {
    }

    public static interface UpdateCamera {
        public void addQueue(Runnable var1);

        public void updateCamera(ViewableGeomFeature var1);
    }

    private class UpdateCameraRunnable
    implements Runnable {
        private UpdateCamera robotCanvas3D;

        public UpdateCameraRunnable(UpdateCamera robotCanvas3D) {
            this.robotCanvas3D = robotCanvas3D;
        }

        @Override
        public void run() {
            this.robotCanvas3D.updateCamera(ViewableGeomFeature.this);
        }
    }
}

