/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.j3dcomponents;

import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.j3dcomponents.MouseListenerSupport;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.GrayFilter;

public class J3DButton
implements J3DComponent {
    private static final int TEXT_HEIGHT = 18;
    private String name;
    private Color borderColor;
    private final Image image;
    private final String text;
    protected MouseListenerSupport mouseListeners = new MouseListenerSupport();
    private final Rectangle bounds = new Rectangle();
    private Color background = Color.WHITE;
    private boolean isVisible;
    private boolean isPressed;
    private boolean isEntered;
    private int textHeight = 18;
    private boolean isEnabled = true;
    private Image disabledImage;

    public J3DButton(String text, Image image, int width, int height) {
        this.text = text;
        this.image = image;
        this.bounds.width = width;
        this.bounds.height = height + 18;
        this.isVisible = true;
    }

    protected J3DButton(String text, Image image) {
        this.text = text;
        this.image = image;
        this.isVisible = true;
    }

    private void handleInBoundsMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 500: {
                this.isPressed = false;
                this.mouseListeners.fireMouseClicked(mouseEvent);
                break;
            }
            case 501: {
                this.isPressed = true;
                this.mouseListeners.fireMousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.isPressed = false;
                this.mouseListeners.fireMouseReleased(mouseEvent);
                this.mouseListeners.fireMouseClicked(this.createMouseClickedEvent(mouseEvent));
                break;
            }
        }
    }

    private MouseEvent createMouseClickedEvent(MouseEvent mouseEvent) {
        return new MouseEvent(mouseEvent.getComponent(), 500, mouseEvent.getWhen(), mouseEvent.getModifiers(), this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.y, mouseEvent.getClickCount(), false, mouseEvent.getButton());
    }

    @Override
    public void dispatchEvent(AWTEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (this.bounds.contains(mouseEvent.getX(), mouseEvent.getY()) && mouseEvent.getButton() == 1) {
                this.handleInBoundsMouseEvent(mouseEvent);
            } else if (this.bounds.contains(mouseEvent.getX(), mouseEvent.getY()) && !this.isEntered) {
                this.isEntered = true;
                this.mouseListeners.fireMouseEntered(mouseEvent);
            } else if (this.isEntered && !this.bounds.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.isEntered = false;
                if (this.isPressed) {
                    this.isPressed = false;
                    this.mouseListeners.fireMouseReleased(mouseEvent);
                }
                this.mouseListeners.fireMouseExited(mouseEvent);
            }
        } else {
            throw new RuntimeException("Unsupported class type '" + event.getClass() + "':\n\t" + event.toString());
        }
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public void setPressed(boolean isPressed) {
        this.isPressed = isPressed;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setLocation(int x, int y) {
        this.bounds.x = x;
        this.bounds.y = y;
    }

    public Color getBackground() {
        return this.background;
    }

    public int getTextHeight() {
        return this.textHeight;
    }

    public void setTextHeight(int textHeight) {
        this.textHeight = textHeight;
    }

    public Image getImage() {
        return this.image;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(int width, int height) {
        this.bounds.width = width;
        this.bounds.height = height;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.isPressed) {
            g2d.setColor(this.background.darker());
            g2d.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height - this.getTextHeight());
        }
        if (this.isEnabled()) {
            g2d.drawImage(this.image, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height - this.getTextHeight(), null, null);
        } else {
            if (this.disabledImage == null) {
                this.disabledImage = GrayFilter.createDisabledImage(this.image);
            }
            g2d.drawImage(this.disabledImage, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height - this.getTextHeight(), null, null);
        }
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height - this.getTextHeight());
        }
        if (this.text != null) {
            g2d.setColor(this.isEnabled() ? Color.BLACK : Color.GRAY);
            g2d.setFont(g2d.getFont().deriveFont(1));
            this.drawText(g2d, this.text, this.bounds.x + this.bounds.width / 2, this.bounds.y + this.bounds.height);
        }
    }

    private void drawText(Graphics2D g2d, String text, int centerX, int startY) {
        int width = (int)g2d.getFont().getStringBounds(text, g2d.getFontRenderContext()).getWidth();
        g2d.drawString(text, centerX - width / 2, startY);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListeners.addMouseListener(mouseListener);
    }
}

