/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.j3dcomponents;

import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.j3dcomponents.J3DTextUtils;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.util.Collections;
import java.util.List;

public class J3DLabel
implements J3DComponent {
    private String name;
    private Color borderColor;
    private final String text;
    private List<String> textAsLines;
    private final Rectangle bounds = new Rectangle();
    private Color background = Color.WHITE;
    private boolean isVisible;
    private boolean isPressed;
    private boolean isEnabled = true;
    private Font font;

    public J3DLabel(String text) {
        this.text = text;
        this.textAsLines = Collections.emptyList();
    }

    @Override
    public void dispatchEvent(AWTEvent event) {
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public void setPressed(boolean isPressed) {
        this.isPressed = isPressed;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setLocation(int x, int y) {
        this.bounds.x = x;
        this.bounds.y = y;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(int width, int height) {
        this.bounds.width = width;
        this.bounds.height = height;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void render(Graphics2D g2d) {
        Font oldFont = g2d.getFont();
        if (this.font != null) {
            g2d.setFont(this.font);
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.background != null) {
            g2d.setColor(this.background);
            g2d.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
        if (this.text != null) {
            Font g2dfont = g2d.getFont();
            FontRenderContext context = g2d.getFontRenderContext();
            g2d.setColor(this.isEnabled() ? Color.BLACK : Color.GRAY);
            if (this.textAsLines.isEmpty()) {
                this.textAsLines = J3DTextUtils.splitIntoLines(this.text, g2dfont, context, this.bounds.width);
            }
            int newHeight = 0;
            int fontSize = g2d.getFont().getSize();
            int i = 0;
            while (i < this.textAsLines.size()) {
                g2d.drawString(this.textAsLines.get(i), this.bounds.x + 10, this.bounds.y + i * fontSize + fontSize + 2);
                newHeight += 14;
                ++i;
            }
            this.bounds.setSize((int)this.bounds.getWidth(), newHeight + fontSize + 2);
        }
        g2d.setFont(oldFont);
    }
}

