/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.j3dcomponents;

import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.UIManager;

public class J3DSlider
implements J3DComponent {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Color background = Color.WHITE;
    private Rectangle bounds = new Rectangle();
    private double value;
    private boolean showTicks;
    private boolean isPressed;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    private void handleInBoundsMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 500: {
                this.isPressed = false;
                this.notifyValueChange(mouseEvent);
                break;
            }
            case 501: {
                this.isPressed = true;
                this.notifyValueChange(mouseEvent);
                break;
            }
            case 502: {
                this.isPressed = false;
                break;
            }
            case 504: {
                break;
            }
        }
    }

    @Override
    public void dispatchEvent(AWTEvent event) {
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (!this.bounds.contains(mouseEvent.getX(), mouseEvent.getY()) && this.isPressed) {
                this.isPressed = false;
            }
            if (this.bounds.contains(mouseEvent.getX(), mouseEvent.getY()) && mouseEvent.getButton() == 1) {
                this.handleInBoundsMouseEvent(mouseEvent);
            }
            if (this.isPressed && mouseEvent.getID() == 506) {
                this.notifyValueChange(mouseEvent);
            }
        } else {
            throw new RuntimeException("Unsupported class type '" + event.getClass() + "':\n\t" + event.toString());
        }
    }

    private void notifyValueChange(MouseEvent mouseEvent) {
        double yValue = -(this.bounds.getY() - (double)mouseEvent.getY());
        double newValue = yValue / this.bounds.getHeight();
        PropertyChangeEvent event = new PropertyChangeEvent(this, "value", null, newValue);
        this.propertyChangeSupport.firePropertyChange(event);
        mouseEvent.consume();
    }

    public void setValue(double value) {
        this.value = PrimitiveUtils.between((double)value, (double)0.0, (double)1.0);
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String name) {
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setShowTicks(boolean showTicks) {
        this.showTicks = showTicks;
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.background != null) {
            g2d.setColor(new Color(this.background.getRed(), this.background.getGreen(), this.background.getBlue(), 160));
            g2d.fillRect(this.bounds.x, this.bounds.y + 1, this.bounds.width + 1, this.bounds.height - 1);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(this.bounds.x, this.bounds.y);
        g2d.setColor(Color.GRAY);
        if (this.showTicks) {
            g2d.fillRect(10, 0, 12, 2);
            g2d.fillRect(8, this.bounds.height / 6 * 1, 16, 2);
            g2d.fillRect(10, this.bounds.height / 6 * 2, 12, 2);
        }
        g2d.fillRect(8, this.bounds.height / 2, 16, 2);
        if (this.showTicks) {
            g2d.fillRect(10, this.bounds.height / 6 * 4, 12, 2);
            g2d.fillRect(8, this.bounds.height / 6 * 5, 16, 2);
            g2d.fillRect(10, this.bounds.height - 2, 12, 2);
        }
        g2d.fillRect(15, 2, 2, this.bounds.height - 4);
        g2d.setColor(UIManager.getColor("Slider.trackColor"));
        g2d.fillOval(8, (int)((double)(this.bounds.height - 9) * this.value), 16, 16);
        g2d.translate(-this.bounds.x, -this.bounds.y);
    }
}

