/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.j3dcomponents;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.List;

class J3DTextUtils {
    private static final int BOUND_MAX_WIDTH_OFFSET = 10;
    private static final String WORD_SEPARATOR = " ";
    private static final String TRUNCATED_EXTENSION = "...";
    private static final int TRUNCATED_EXTENSION_PIXELS_SIZE = 15;

    J3DTextUtils() {
    }

    public static List<String> splitIntoLines(String text, Font font, FontRenderContext context, int maxWidth) {
        ArrayList<String> result = new ArrayList<String>();
        String[] words = text.split(WORD_SEPARATOR);
        String line = "";
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            boolean lineIsOutOfRectangleBounds;
            boolean wordIsOutOfRectangleBounds;
            String word = stringArray[n2];
            boolean bl = wordIsOutOfRectangleBounds = font.getStringBounds(word, context).getWidth() > (double)(maxWidth - 10);
            if (wordIsOutOfRectangleBounds) {
                word = J3DTextUtils.truncateWord(word, font, context, maxWidth);
            }
            boolean bl2 = lineIsOutOfRectangleBounds = font.getStringBounds(String.valueOf(line) + WORD_SEPARATOR + word, context).getWidth() > (double)(maxWidth - 10);
            if (lineIsOutOfRectangleBounds) {
                if (!line.isEmpty()) {
                    result.add(line.trim());
                }
                line = word;
            } else {
                line = String.valueOf(line) + WORD_SEPARATOR + word;
            }
            ++n2;
        }
        if (!line.isEmpty()) {
            result.add(line.trim());
        }
        return result;
    }

    private static String truncateWord(String word, Font font, FontRenderContext context, int maxWidth) {
        double wordWidth = font.getStringBounds(word, context).getWidth();
        String truncatedWord = word;
        while (wordWidth > (double)(maxWidth - 10 - 15)) {
            truncatedWord = truncatedWord.substring(0, truncatedWord.length() - 1);
            wordWidth = font.getStringBounds(truncatedWord, context).getWidth();
        }
        truncatedWord = String.valueOf(truncatedWord) + TRUNCATED_EXTENSION;
        return truncatedWord;
    }
}

