/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.j3dcomponents;

import com.ur.polyscope.visualizer.j3dcomponents.J3DButton;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.event.MouseEvent;

public class J3DToggleButton
extends J3DButton {
    private boolean isToggled;
    private Color borderColor = G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE;

    public J3DToggleButton(String text, Image image, int width, int height) {
        super(text, image);
        this.setBounds(width, height);
        this.setTextHeight(0);
        this.isToggled = false;
    }

    private MouseEvent createNewMouseReleaseEvent(MouseEvent mouseEvent) {
        return new MouseEvent(mouseEvent.getComponent(), 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), this.getBounds().x, this.getBounds().y, this.getBounds().x, this.getBounds().y, mouseEvent.getClickCount(), false, mouseEvent.getButton());
    }

    private void handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500) {
            this.setPressed(false);
            if (this.isToggled) {
                this.setToggled(false);
            } else {
                this.setToggled(true);
            }
            this.mouseListeners.fireMouseClicked(mouseEvent);
        }
    }

    @Override
    public void dispatchEvent(AWTEvent event) {
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (this.isVisible() && !this.getBounds().contains(mouseEvent.getX(), mouseEvent.getY()) && this.isPressed()) {
                this.setPressed(false);
                this.mouseListeners.fireMouseReleased(this.createNewMouseReleaseEvent(mouseEvent));
            }
            if (this.isVisible() && this.getBounds().contains(mouseEvent.getX(), mouseEvent.getY()) && mouseEvent.getButton() == 1) {
                this.handleMouseEvent(mouseEvent);
            }
        } else {
            throw new RuntimeException("Unsupported class type '" + event.getClass() + "':\n\t" + event.toString());
        }
    }

    public boolean isToggled() {
        return this.isToggled;
    }

    public void setToggled(boolean isToggled) {
        this.isToggled = isToggled;
    }

    @Override
    public void render(Graphics2D g2d) {
        Stroke initStroke = g2d.getStroke();
        g2d.setColor(this.isToggled ? this.getBackground().darker() : this.getBackground());
        g2d.fillRect(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.setColor(Color.BLACK);
        int widthSpacing = this.getBounds().width - this.getImage().getWidth(null);
        widthSpacing = widthSpacing < 0 ? 0 : (widthSpacing /= 2);
        int hightSpacing = this.getBounds().height - (this.getImage().getHeight(null) + this.getTextHeight());
        hightSpacing = hightSpacing < 0 ? 0 : (hightSpacing /= 2);
        g2d.drawImage(this.getImage(), this.getBounds().x + widthSpacing, this.getBounds().y + hightSpacing, this.getImage().getWidth(null), this.getImage().getHeight(null), null, null);
        g2d.setColor(this.borderColor);
        g2d.drawRect(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        g2d.setStroke(initStroke);
    }
}

