/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.panel;

import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import java.util.Set;
import javax.inject.Inject;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;

public class ElementsVisualizerAggregator
implements ElementsVisualizer {
    private final Set<ElementsVisualizer> visualizers;
    private final RobotCanvas3DFactory factory;

    @Inject
    public ElementsVisualizerAggregator(Set<ElementsVisualizer> visualizers, RobotCanvas3DFactory factory) {
        this.visualizers = visualizers;
        this.factory = factory;
    }

    @Override
    public Node getElementNode() {
        if (this.factory != null && this.factory.hasActualCanvas()) {
            BranchGroup result = new BranchGroup();
            for (ElementsVisualizer each : this.visualizers) {
                result.addChild(each.getElementNode());
            }
            return result;
        }
        return null;
    }

    @Override
    public void initialize() {
        if (this.factory != null && this.factory.hasActualCanvas()) {
            for (ElementsVisualizer each : this.visualizers) {
                each.initialize();
            }
        }
    }

    @Override
    public void clearVisualization() {
        if (this.factory != null && this.factory.hasActualCanvas()) {
            for (ElementsVisualizer each : this.visualizers) {
                each.clearVisualization();
            }
        }
    }

    @Override
    public void displayProximity(Pose6d tcpPose) {
        if (this.factory != null && this.factory.hasActualCanvas()) {
            for (ElementsVisualizer each : this.visualizers) {
                each.displayProximity(tcpPose);
            }
        }
    }
}

