/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.panel;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.URCanvas3DFingerDragViewShifter;
import com.ur.polyscope.visualizer.internal.VisualizerTextResource;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import com.ur.swing.ViewContext;
import com.ur.util.Optional;
import com.ur.util.event.EventNotificationService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class RobotView3DPanel
extends JPanel
implements RobotStateListener {
    private static final String INKOGNITO = "inkognito";
    private final RobotCanvas3DFactory robotCanvas3DFactory;
    private final ControllerInterface controllerInterface;
    private final ViewContext viewContext;
    protected RobotCanvas3D robotCanvas3D;
    private JPanel graphicsPanel;
    private Optional<ElementsVisualizer> elementVisualizers = Optional.empty();
    private String debugCanvasName;

    @Inject
    public RobotView3DPanel(RobotCanvas3DFactory factory, ControllerInterface controllerInterface, ViewContext viewContext) {
        this(factory, controllerInterface, viewContext, null);
    }

    public RobotView3DPanel(RobotCanvas3DFactory robotCanvas3DFactory, ControllerInterface controllerInterface, ViewContext viewContext, String debugCanvasName) {
        this.robotCanvas3DFactory = robotCanvas3DFactory;
        this.controllerInterface = controllerInterface;
        this.viewContext = viewContext;
        this.debugCanvasName = debugCanvasName;
        this.initComponents();
        this.init3DGraphics();
    }

    protected boolean isActive() {
        return this.robotCanvas3D.getComponent().isVisible();
    }

    public void setActive(boolean active) {
        if (this.isActive() == active) {
            return;
        }
        if (!active) {
            this.robotCanvas3D.addQueue(new ClearVisualizationRunnable());
        }
        this.robotCanvas3D.setVisible(active);
        if (active) {
            EventNotificationService.register((Object)this, RobotStateListener.class, (Object)this);
        } else {
            EventNotificationService.unregister((Object)this, RobotStateListener.class);
        }
    }

    private void init3DGraphics() {
        this.robotCanvas3D = this.robotCanvas3DFactory.buildMetalRobot();
        this.robotCanvas3D.setDebugName(this.debugCanvasName);
        this.graphicsPanel.add(this.robotCanvas3D.getComponent());
        new URCanvas3DFingerDragViewShifter(this.robotCanvas3D);
    }

    public void updateRobotState(RobotState robotState) {
        this.robotCanvas3D.addQueue(new UpdateGraphicsRunnable(robotState));
    }

    public RobotCanvas3D getRobotCanvas3D() {
        return this.robotCanvas3D;
    }

    public void setElementVisualizers(ElementsVisualizer elementVisualizers) {
        this.elementVisualizers = Optional.of((Object)elementVisualizers);
    }

    private void initComponents() {
        this.graphicsPanel = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder(((VisualizerTextResource)this.viewContext.getTextResource(VisualizerTextResource.class))._3DView()));
        this.setFocusTraversalPolicyProvider(true);
        this.setPreferredSize(new Dimension(100, 35));
        this.setLayout(new BorderLayout());
        this.graphicsPanel.setLayout(new BorderLayout());
        this.add((Component)this.graphicsPanel, "Center");
    }

    public void setDebugName(String debugName) {
        this.robotCanvas3D.setDebugName(debugName);
    }

    private class ClearVisualizationRunnable
    implements Runnable {
        private ClearVisualizationRunnable() {
        }

        @Override
        public void run() {
            if (RobotView3DPanel.this.elementVisualizers.isPresent()) {
                ((ElementsVisualizer)RobotView3DPanel.this.elementVisualizers.get()).clearVisualization();
            }
        }
    }

    private class UpdateGraphicsRunnable
    implements Runnable {
        private RobotState robotState;

        public UpdateGraphicsRunnable(RobotState robotState) {
            this.robotState = robotState;
        }

        @Override
        public void run() {
            RobotView3DPanel.this.robotCanvas3D.setJointAngleVector(this.robotState.jointPosition);
            if (RobotView3DPanel.this.elementVisualizers.isPresent()) {
                if (!RobotView3DPanel.this.controllerInterface.isControllerAvailable() || !this.robotState.hasReceivedPositionData || this.robotState.programRunning && !EqualsUtil.equals((Object)this.robotState.getCurrentProgramName(), (Object)RobotView3DPanel.INKOGNITO)) {
                    ((ElementsVisualizer)RobotView3DPanel.this.elementVisualizers.get()).clearVisualization();
                } else {
                    ((ElementsVisualizer)RobotView3DPanel.this.elementVisualizers.get()).displayProximity(this.robotState.tool);
                }
            }
        }
    }
}

