/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.utils;

import java.awt.Color;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.media.j3d.Material;
import javax.vecmath.Color3f;

public final class MaterialDB {
    private static final Color3f BLACK = new Color3f(Color.BLACK);
    private static Map<MaterialID, Material> MATERIALS = new EnumMap<MaterialID, Material>(MaterialID.class);

    static {
        MaterialDB.addMaterial(MaterialID.EMERALD, 0.0215, 0.1745, 0.0215, 0.07568, 0.61424, 0.07568, 0.633, 0.727811, 0.633, 0.6);
        MaterialDB.addMaterial(MaterialID.JADE, 0.135, 0.2225, 0.1575, 0.54, 0.89, 0.63, 0.316228, 0.316228, 0.316228, 0.1);
        MaterialDB.addMaterial(MaterialID.OBSIDIAN, 0.05375, 0.05, 0.06625, 0.18275, 0.17, 0.22525, 0.332741, 0.328634, 0.346435, 0.3);
        MaterialDB.addMaterial(MaterialID.PEARL, 0.25, 0.20725, 0.20725, 1.0, 0.829, 0.829, 0.296648, 0.296648, 0.296648, 0.088);
        MaterialDB.addMaterial(MaterialID.RUBY, 0.1745, 0.01175, 0.01175, 0.61424, 0.04136, 0.04136, 0.727811, 0.626959, 0.626959, 0.6);
        MaterialDB.addMaterial(MaterialID.TURQUOISE, 0.1, 0.18725, 0.1745, 0.396, 0.74151, 0.69102, 0.297254, 0.30829, 0.306678, 0.1);
        MaterialDB.addMaterial(MaterialID.BRASS, 0.329412, 0.223529, 0.027451, 0.780392, 0.568627, 0.113725, 0.992157, 0.941176, 0.807843, 0.21794872);
        MaterialDB.addMaterial(MaterialID.BRONZE, 0.2125, 0.1275, 0.054, 0.714, 0.4284, 0.18144, 0.393548, 0.271906, 0.166721, 0.2);
        MaterialDB.addMaterial(MaterialID.CHROME, 0.25, 0.25, 0.25, 0.4, 0.4, 0.4, 0.774597, 0.774597, 0.774597, 0.6);
        MaterialDB.addMaterial(MaterialID.COPPER, 0.19125, 0.0735, 0.0225, 0.7038, 0.27048, 0.0828, 0.256777, 0.137622, 0.086014, 0.1);
        MaterialDB.addMaterial(MaterialID.GOLD, 0.24725, 0.1995, 0.0745, 0.75164, 0.60648, 0.22648, 0.628281, 0.555802, 0.366065, 0.4);
        MaterialDB.addMaterial(MaterialID.SILVER, 0.19225, 0.19225, 0.19225, 0.50754, 0.50754, 0.50754, 0.508273, 0.508273, 0.508273, 0.4);
        MaterialDB.addMaterial(MaterialID.BLACK_PLASTIC, 0.0, 0.0, 0.0, 0.01, 0.01, 0.01, 0.5, 0.5, 0.5, 0.25);
        MaterialDB.addMaterial(MaterialID.CYAN_PLASTIC, 0.0, 0.1, 0.06, 0.0, 0.50980392, 0.50980392, 0.50196078, 0.50196078, 0.50196078, 0.25);
        MaterialDB.addMaterial(MaterialID.GREEN_PLASTIC, 0.0, 0.0, 0.0, 0.375, 0.5, 0.375, 0.57, 0.75, 0.57, 0.25);
        MaterialDB.addMaterial(MaterialID.RED_PLASTIC, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.7, 0.6, 0.6, 0.25);
        MaterialDB.addMaterial(MaterialID.WHITE_PLASTIC, 0.0, 0.0, 0.0, 0.55, 0.55, 0.55, 0.7, 0.7, 0.7, 0.25);
        MaterialDB.addMaterial(MaterialID.YELLOW_PLASTIC, 0.0, 0.0, 0.0, 0.5, 0.5, 0.0, 0.6, 0.6, 0.5, 0.25);
        MaterialDB.addMaterial(MaterialID.CYAN_RUBBER, 0.0, 0.05, 0.05, 0.4, 0.5, 0.5, 0.04, 0.7, 0.7, 0.078125);
        MaterialDB.addMaterial(MaterialID.GREEN_RUBBER, 0.0, 0.05, 0.0, 0.4, 0.5, 0.4, 0.04, 0.7, 0.04, 0.078125);
        MaterialDB.addMaterial(MaterialID.RED_RUBBER, 0.05, 0.0, 0.0, 0.5, 0.4, 0.4, 0.7, 0.04, 0.04, 0.078125);
        MaterialDB.addMaterial(MaterialID.WHITE_RUBBER, 0.05, 0.05, 0.05, 0.5, 0.5, 0.5, 0.7, 0.7, 0.7, 0.078125);
        MaterialDB.addMaterial(MaterialID.YELLOW_RUBBER, 0.05, 0.05, 0.0, 0.5, 0.5, 0.4, 0.7, 0.7, 0.04, 0.078125);
        MaterialDB.addMaterial(MaterialID.PEWTER, 0.105882, 0.058824, 0.113725, 0.427451, 0.470588, 0.541176, 0.3333333, 0.3333333, 0.521569, 0.1);
        MaterialDB.addMaterial(MaterialID.BLACK_RUBBER, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.4, 0.4, 0.4, 0.1);
        MaterialDB.addMaterial(MaterialID.BLUE_PLASTIC, 0.0, 0.0, 0.0, 0.13, 0.36, 0.69, 0.45, 0.45, 0.55, 0.55);
        MaterialDB.addMaterial(MaterialID.BROWN_PLASTIC, 0.1, 0.05, 0.0, 0.4, 0.2, 0.0, 0.5, 0.5, 0.5, 0.25);
        MATERIALS = Collections.unmodifiableMap(MATERIALS);
    }

    private MaterialDB() {
    }

    public static Material get(MaterialID id) {
        return MATERIALS.get((Object)id);
    }

    private static void addMaterial(MaterialID materialID, double ambientR, double ambientG, double ambientB, double diffuseR, double diffuseG, double diffuseB, double specularR, double specularG, double specularB, double shininessZeroToOne) {
        Color3f ambient = new Color3f((float)ambientR, (float)ambientG, (float)ambientB);
        Color3f emissive = BLACK;
        Color3f diffuse = new Color3f((float)diffuseR, (float)diffuseG, (float)diffuseB);
        Color3f specular = new Color3f((float)specularR, (float)specularG, (float)specularB);
        float shininess = MaterialDB.linearTransform((float)shininessZeroToOne, 0.0f, 1.0f, 1.0f, 128.0f);
        Material material = new Material(ambient, emissive, diffuse, specular, shininess);
        MATERIALS.put(materialID, material);
    }

    private static float linearTransform(float value, float sMin, float sMax, float dMin, float dMax) {
        float multFactor = (dMax - dMin) / (sMax - sMin);
        float shift = multFactor * sMin - dMin;
        return multFactor * value - shift;
    }

    public static enum MaterialID {
        EMERALD,
        JADE,
        OBSIDIAN,
        PEARL,
        RUBY,
        TURQUOISE,
        BRASS,
        BRONZE,
        CHROME,
        COPPER,
        GOLD,
        SILVER,
        BLACK_PLASTIC,
        CYAN_PLASTIC,
        GREEN_PLASTIC,
        RED_PLASTIC,
        WHITE_PLASTIC,
        YELLOW_PLASTIC,
        CYAN_RUBBER,
        GREEN_RUBBER,
        RED_RUBBER,
        WHITE_RUBBER,
        YELLOW_RUBBER,
        PEWTER,
        BLACK_RUBBER,
        BLUE_PLASTIC,
        BROWN_PLASTIC;

    }
}

