/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.j3d;

import java.util.ArrayList;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Helix
extends Shape3D {
    private Vector3d _end;
    private static double _length = 30.0;
    private static double _radius = 12.0;

    public Helix(int charge, double eta, double phi, double pt, double v_phi, double v_rho, double v_z, double mField, int granularity, Appearance appearance) {
        if (charge == 0) {
            this.constructNeutral(eta, pt, v_phi, v_rho, v_z, appearance);
        } else {
            this.constructCharged(charge, eta, phi, pt, v_phi, v_rho, v_z, mField, granularity, appearance);
        }
    }

    private void constructNeutral(double eta, double phi, double v_phi, double v_rho, double v_z, Appearance appearance) {
        Point3d start = new Point3d(v_rho * Math.cos(v_phi), v_rho * Math.sin(v_phi), v_z);
        Point3d end0 = new Point3d(start.x, start.y, start.z);
        double tant = 2.0 / (Math.exp(eta) - Math.exp(-eta));
        if (tant > _length / _radius) {
            end0.add((Tuple3d)new Point3d(_radius * Math.cos(phi), _radius * Math.sin(phi), _radius * tant));
        } else {
            end0.add((Tuple3d)new Point3d(_length * Math.cos(phi) / tant, _length * Math.sin(phi) / tant, _length));
        }
        int[] counts = new int[]{2};
        LineStripArray lineArray = new LineStripArray(2, 3, counts);
        float[] normal = new float[]{0.0f, 0.0f, 0.0f};
        lineArray.setCoordinate(0, start);
        lineArray.setCoordinate(1, end0);
        lineArray.setNormal(0, normal);
        this.setGeometry((Geometry)lineArray);
        this._end = new Vector3d((Tuple3d)end0);
        this.setAppearance(appearance);
    }

    private void constructCharged(int charge, double eta, double phi, double pt, double v_phi, double v_rho, double v_z, double mField, int granularity, Appearance appearance) {
        double rx = v_rho * Math.cos(v_phi);
        double ry = v_rho * Math.sin(v_phi);
        double rz = v_z;
        double px = pt * Math.cos(phi);
        double py = pt * Math.sin(phi);
        double pz = pt / 2.0 * (Math.exp(eta) - Math.exp(-eta));
        double sigma = pt / mField / 0.3;
        double alpha = sigma * pz / pt;
        double sx = rx - py * sigma * (double)charge;
        double sy = ry + px * sigma * (double)charge;
        double st = Math.sqrt(sx * sx + sy * sy);
        double dx = (1.0 - sigma * pt / st) * sx;
        double dy = (1.0 - sigma * pt / st) * sy;
        double sin_dphi_2 = Math.sqrt((rx - dx) * (rx - dx) + (ry - dy) * (ry - dy)) / 2.0 / sigma;
        double cos_dphi_2 = Math.sqrt(1.0 - sin_dphi_2 * sin_dphi_2);
        double dphi = 2.0 * Math.atan2(sin_dphi_2, cos_dphi_2);
        if ((rx - dx) * px + (ry - dy) * py > 0.0) {
            dphi = -dphi;
        }
        double phi0 = Math.atan2(ry - sy, rx - sx);
        double delta = Math.PI * 2 / (double)granularity / pt;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i = 0;
        double w = 0.0;
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        if (Math.sqrt(rx * rx + ry * ry) < _radius && Math.abs(rz) < _length / 2.0) {
            do {
                x = rx + sigma * (Math.cos(phi0) - Math.cos((double)(-charge) * delta * w + phi0));
                y = ry + sigma * (Math.sin(phi0) - Math.sin((double)(-charge) * delta * w + phi0));
                z = rz + alpha * delta * w;
                points.add(new Point3d(x, y, z));
                w += 1.0;
            } while (Math.sqrt(x * x + y * y) < _radius && Math.abs(z) < _length / 2.0 && ++i < granularity);
        }
        if (i > 0) {
            int[] counts = new int[]{points.size()};
            LineStripArray lineArray = new LineStripArray(points.size(), 3, counts);
            float[] normal = new float[]{0.0f, 0.0f, 0.0f};
            int j = 0;
            Iterator it = points.iterator();
            while (it.hasNext()) {
                lineArray.setCoordinate(j++, (Point3d)it.next());
            }
            lineArray.setNormal(0, normal);
            this.setGeometry((Geometry)lineArray);
            this._end = new Vector3d(x, y, z);
        }
        this.setAppearance(appearance);
    }

    public Vector3d end() {
        return this._end;
    }

    public static void cutAt(double length, double radius) {
        _length = length;
        _radius = radius;
    }
}

