/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import javax.media.j3d.Appearance;
import javax.vecmath.Point3d;
import org.freehep.j3d.Solid;

public class ConeSegment
extends Solid {
    private GeometryInfo _topGeometry;
    private GeometryInfo _bottomGeometry;
    private GeometryInfo _inGeometry;
    private GeometryInfo _outGeometry;
    private GeometryInfo _leftGeometry;
    private GeometryInfo _rightGeometry;

    public ConeSegment(double rminm, double rminp, double rmaxm, double rmaxp, double l, double phimin, double phimax, int granularity, Appearance appearance) {
        this.construct(rminm, rminp, rmaxm, rmaxp, l, phimin, phimax, granularity, appearance);
    }

    public ConeSegment(double rmin, double rmax, double l, double phimin, double phimax, int granularity, Appearance appearance) {
        this.construct(rmin, rmin, rmax, rmax, l, phimin, phimax, granularity, appearance);
    }

    public ConeSegment(double rmin, double rmax, double l, int granularity, Appearance appearance) {
        this.construct(rmin, rmin, rmax, rmax, l, 0.0, 360.0, granularity, appearance);
    }

    public ConeSegment(double r, double l, int granularity, Appearance appearance) {
        this.construct(0.0, 0.0, r, r, l, 0.0, 360.0, granularity, appearance);
    }

    private void construct(double rminm, double rminp, double rmaxm, double rmaxp, double l, double phimin, double phimax, int granularity, Appearance appearance) {
        int count = 4 * granularity;
        double phimin0 = Math.toRadians(phimin);
        double phimax0 = Math.toRadians(phimax);
        Point3d pminp = new Point3d();
        Point3d pmaxp = new Point3d();
        Point3d pminm = new Point3d();
        Point3d pmaxm = new Point3d();
        Point3d[] topCoordinates = new Point3d[count];
        Point3d[] bottomCoordinates = new Point3d[count];
        Point3d[] inCoordinates = new Point3d[count];
        Point3d[] outCoordinates = new Point3d[count];
        Point3d[] leftCoordinates = new Point3d[4];
        Point3d[] rightCoordinates = new Point3d[4];
        double phi = phimin0;
        for (int i = -2; i < count; i += 4) {
            pminp.set(rminp * Math.cos(phi), rminp * Math.sin(phi), l / 2.0);
            pmaxp.set(rmaxp * Math.cos(phi), rmaxp * Math.sin(phi), l / 2.0);
            pminm.set(rminm * Math.cos(phi), rminm * Math.sin(phi), -l / 2.0);
            pmaxm.set(rmaxm * Math.cos(phi), rmaxm * Math.sin(phi), -l / 2.0);
            if (i > 0) {
                topCoordinates[i] = new Point3d(pmaxp);
                topCoordinates[i + 1] = new Point3d(pminp);
            }
            if (i < count - 4) {
                topCoordinates[i + 2] = new Point3d(pminp);
                topCoordinates[i + 3] = new Point3d(pmaxp);
            }
            if (i > 0) {
                bottomCoordinates[i + 1] = new Point3d(pmaxm);
                bottomCoordinates[i] = new Point3d(pminm);
            }
            if (i < count - 4) {
                bottomCoordinates[i + 3] = new Point3d(pminm);
                bottomCoordinates[i + 2] = new Point3d(pmaxm);
            }
            if (i > 0) {
                inCoordinates[i + 1] = new Point3d(pminm);
                inCoordinates[i] = new Point3d(pminp);
            }
            if (i < count - 4) {
                inCoordinates[i + 3] = new Point3d(pminp);
                inCoordinates[i + 2] = new Point3d(pminm);
            }
            if (i > 0) {
                outCoordinates[i] = new Point3d(pmaxm);
                outCoordinates[i + 1] = new Point3d(pmaxp);
            }
            if (i < count - 4) {
                outCoordinates[i + 2] = new Point3d(pmaxp);
                outCoordinates[i + 3] = new Point3d(pmaxm);
            }
            phi += (phimax0 - phimin0) / (double)granularity;
        }
        phi -= (phimax0 - phimin0) / (double)granularity;
        if (phimin > 0.0 || phimax < 360.0) {
            leftCoordinates[0] = new Point3d(rminm * Math.cos(phimin0), rminm * Math.sin(phimin0), -l / 2.0);
            leftCoordinates[1] = new Point3d(rmaxm * Math.cos(phimin0), rmaxm * Math.sin(phimin0), -l / 2.0);
            leftCoordinates[2] = new Point3d(rmaxp * Math.cos(phimin0), rmaxp * Math.sin(phimin0), l / 2.0);
            leftCoordinates[3] = new Point3d(rminp * Math.cos(phimin0), rminp * Math.sin(phimin0), l / 2.0);
            rightCoordinates[1] = new Point3d(rminm * Math.cos(phi), rminm * Math.sin(phi), -l / 2.0);
            rightCoordinates[0] = new Point3d(rmaxm * Math.cos(phi), rmaxm * Math.sin(phi), -l / 2.0);
            rightCoordinates[3] = new Point3d(rmaxp * Math.cos(phi), rmaxp * Math.sin(phi), l / 2.0);
            rightCoordinates[2] = new Point3d(rminp * Math.cos(phi), rminp * Math.sin(phi), l / 2.0);
        }
        this._outGeometry = this.addCoordinates(outCoordinates);
        this._inGeometry = this.addCoordinates(inCoordinates);
        this._topGeometry = this.addCoordinates(topCoordinates);
        this._bottomGeometry = this.addCoordinates(bottomCoordinates);
        if (phimin > 0.0 || phimax < 360.0) {
            this._leftGeometry = this.addCoordinates(leftCoordinates);
            this._rightGeometry = this.addCoordinates(rightCoordinates);
        }
        this.setAppearance(appearance);
    }

    GeometryInfo topGeometry() {
        return this._topGeometry;
    }

    GeometryInfo bottomGeometry() {
        return this._bottomGeometry;
    }

    GeometryInfo inGeometry() {
        return this._inGeometry;
    }

    GeometryInfo outGeometry() {
        return this._outGeometry;
    }

    GeometryInfo leftGeometry() {
        return this._leftGeometry;
    }

    GeometryInfo rightGeometry() {
        return this._rightGeometry;
    }
}

