/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;

public class OutlinedShape3D {
    public static final Color3f WHITE = new Color3f(1.0f, 1.0f, 1.0f);
    public static final Color3f BLACK = new Color3f(0.0f, 0.0f, 0.0f);
    public static final Color3f BRIGHT = new Color3f(1.0f, 1.0f, 1.0f);
    public static final Color3f DARK;
    private static Color3f _outlineColor;

    public static Shape3D create(Shape3D shape, Color3f color) {
        Material m;
        if (color == null) {
            return null;
        }
        Shape3D oShape = (Shape3D)shape.cloneNode(false);
        Appearance appearance = (Appearance)shape.getAppearance().cloneNodeComponent(false);
        appearance.setPolygonAttributes(new PolygonAttributes(1, 0, -1.0f, false));
        if (color == BRIGHT) {
            m = oShape.getAppearance().getMaterial();
            m.getDiffuseColor(color);
            color.x *= 1.5f;
            color.y *= 1.5f;
            color.z *= 1.5f;
        } else if (color == DARK) {
            m = oShape.getAppearance().getMaterial();
            m.getDiffuseColor(color);
            color.x /= 3.0f;
            color.y /= 3.0f;
            color.z /= 3.0f;
        }
        Material material = new Material();
        material.setAmbientColor(color);
        material.setDiffuseColor(color);
        material.setEmissiveColor(color);
        material.setShininess(20.0f);
        appearance.setMaterial(material);
        oShape.setAppearance(appearance);
        return oShape;
    }

    public static void setOutlineColor(Color3f oc) {
        _outlineColor = oc;
    }

    public static Color3f outlineColor() {
        return _outlineColor;
    }

    static {
        _outlineColor = DARK = new Color3f(0.0f, 0.0f, 0.0f);
    }
}

