/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.vecmath.Point3d;
import org.freehep.j3d.ConeSegment;
import org.freehep.j3d.Solid;

public class PolyConeSegment
extends Solid {
    public PolyConeSegment(double[] rmins, double[] rmaxs, double[] zs, double phimin, double phimax, int granularity, Appearance appearance) {
        for (int i = 0; i < zs.length - 1; ++i) {
            ConeSegment oneCons = new ConeSegment(rmins[i], rmins[i + 1], rmaxs[i], rmaxs[i + 1], zs[i + 1] - zs[i], phimin, phimax, granularity, appearance);
            this.addCoordinates(this.getCoordinates(oneCons.inGeometry(), (zs[i] + zs[i + 1]) / 2.0));
            this.addCoordinates(this.getCoordinates(oneCons.outGeometry(), (zs[i] + zs[i + 1]) / 2.0));
            if (phimin > 0.0 || phimax < 360.0) {
                this.addCoordinates(this.getCoordinates(oneCons.leftGeometry(), (zs[i] + zs[i + 1]) / 2.0));
                this.addCoordinates(this.getCoordinates(oneCons.rightGeometry(), (zs[i] + zs[i + 1]) / 2.0));
            }
            if (i == zs.length - 2) {
                this.addCoordinates(this.getCoordinates(oneCons.topGeometry(), (zs[i] + zs[i + 1]) / 2.0));
            }
            if (i != 0) continue;
            this.addCoordinates(this.getCoordinates(oneCons.bottomGeometry(), (zs[i] + zs[i + 1]) / 2.0));
        }
        this.setAppearance(appearance);
    }

    private Point3d[] getCoordinates(GeometryInfo gInfo, double z) {
        int j;
        GeometryArray gArray = gInfo.getGeometryArray();
        int start = gArray.getInitialVertexIndex();
        int length = gArray.getValidVertexCount();
        Point3d[] points = new Point3d[length];
        for (j = start; j < length; ++j) {
            points[j] = new Point3d();
        }
        gArray.getCoordinates(start, points);
        for (j = start; j < length; ++j) {
            points[j].z += z;
        }
        return points;
    }
}

