/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d;

import javax.media.j3d.Appearance;
import javax.vecmath.Point3d;
import org.freehep.j3d.Solid;

public class PolyGoneSegment
extends Solid {
    public PolyGoneSegment(double[] rmins, double[] rmaxs, double[] zs, double phimin, double phimax, int sides, Appearance appearance) {
        this.construct(rmins, rmaxs, zs, phimin, phimax, sides, appearance);
    }

    private void construct(double[] rmins, double[] rmaxs, double[] zs, double phimin, double phimax, int sides, Appearance appearance) {
        int i;
        double phimin0 = Math.toRadians(phimin);
        double phimax0 = Math.toRadians(phimax);
        Point3d[][] inner = new Point3d[zs.length][sides + 1];
        Point3d[][] outer = new Point3d[zs.length][sides + 1];
        for (int j = 0; j < sides + 1; ++j) {
            double phi = (double)(2 * j) * Math.PI / (double)sides;
            for (int i2 = 0; i2 < zs.length; ++i2) {
                outer[i2][j] = new Point3d(rmaxs[i2] * Math.cos(phi), rmaxs[i2] * Math.sin(phi), zs[i2]);
                inner[i2][j] = new Point3d(rmins[i2] * Math.cos(phi), rmins[i2] * Math.sin(phi), zs[i2]);
            }
        }
        boolean cutoffMin = phimin > 0.0;
        boolean cutoffMax = phimax < 360.0;
        double delphi = Math.PI * 2 / (double)sides;
        int jmin = (int)(phimin0 / delphi);
        int jmax = (int)(phimax0 / delphi);
        double alphamin = delphi / 2.0 - (phimin0 - (double)jmin * delphi);
        double alphamax = delphi / 2.0 - (phimax0 - (double)jmax * delphi);
        double smin = Math.cos(delphi / 2.0) / Math.cos(alphamin);
        double smax = Math.cos(delphi / 2.0) / Math.cos(alphamax);
        Point3d[] outermin = new Point3d[zs.length];
        Point3d[] innermin = new Point3d[zs.length];
        Point3d[] outermax = new Point3d[zs.length];
        Point3d[] innermax = new Point3d[zs.length];
        for (int i3 = 0; i3 < zs.length; ++i3) {
            outermin[i3] = new Point3d(rmaxs[i3] * smin * Math.cos(phimin0), rmaxs[i3] * smin * Math.sin(phimin0), zs[i3]);
            innermin[i3] = new Point3d(rmins[i3] * smin * Math.cos(phimin0), rmins[i3] * smin * Math.sin(phimin0), zs[i3]);
            outermax[i3] = new Point3d(rmaxs[i3] * smax * Math.cos(phimax0), rmaxs[i3] * smax * Math.sin(phimax0), zs[i3]);
            innermax[i3] = new Point3d(rmins[i3] * smax * Math.cos(phimax0), rmins[i3] * smax * Math.sin(phimax0), zs[i3]);
        }
        Point3d[] coordinates0 = new Point3d[zs.length * sides * 10];
        int k = 0;
        int jstart = jmin;
        if (cutoffMin) {
            jstart = jmin + 1;
        }
        for (i = 0; i < zs.length; ++i) {
            for (int j = jstart; j < jmax; ++j) {
                boolean skip = false;
                int j0 = j + 1;
                if (i == 0) {
                    coordinates0[k + 3] = inner[i][j];
                    coordinates0[k + 2] = inner[i][j0];
                    coordinates0[k + 1] = outer[i][j0];
                    coordinates0[k] = outer[i][j];
                    k += 4;
                }
                if (i == zs.length - 1) {
                    coordinates0[k] = inner[i][j];
                    coordinates0[k + 1] = inner[i][j0];
                    coordinates0[k + 2] = outer[i][j0];
                    coordinates0[k + 3] = outer[i][j];
                    k += 4;
                }
                if (i <= 0) continue;
                coordinates0[k] = outer[i][j];
                coordinates0[k + 1] = outer[i][j0];
                coordinates0[k + 2] = outer[i - 1][j0];
                coordinates0[k + 3] = outer[i - 1][j];
                coordinates0[(k += 4) + 3] = inner[i][j];
                coordinates0[k + 2] = inner[i][j0];
                coordinates0[k + 1] = inner[i - 1][j0];
                coordinates0[k] = inner[i - 1][j];
                k += 4;
            }
        }
        if (cutoffMin) {
            coordinates0[k] = inner[0][jmin + 1];
            coordinates0[k + 1] = innermin[0];
            coordinates0[k + 2] = outermin[0];
            coordinates0[k + 3] = outer[0][jmin + 1];
            coordinates0[(k += 4) + 3] = inner[zs.length - 1][jmin + 1];
            coordinates0[k + 2] = innermin[zs.length - 1];
            coordinates0[k + 1] = outermin[zs.length - 1];
            coordinates0[k] = outer[zs.length - 1][jmin + 1];
            k += 4;
        }
        if (cutoffMax) {
            coordinates0[k] = innermax[0];
            coordinates0[k + 1] = inner[0][jmax];
            coordinates0[k + 2] = outer[0][jmax];
            coordinates0[k + 3] = outermax[0];
            coordinates0[(k += 4) + 3] = innermax[zs.length - 1];
            coordinates0[k + 2] = inner[zs.length - 1][jmax];
            coordinates0[k + 1] = outer[zs.length - 1][jmax];
            coordinates0[k] = outermax[zs.length - 1];
            k += 4;
        }
        for (i = 1; i < zs.length; ++i) {
            if (cutoffMin) {
                coordinates0[k + 3] = outer[i][jmin + 1];
                coordinates0[k + 2] = outermin[i];
                coordinates0[k + 1] = outermin[i - 1];
                coordinates0[k] = outer[i - 1][jmin + 1];
                coordinates0[k += 4] = inner[i][jmin + 1];
                coordinates0[k + 1] = innermin[i];
                coordinates0[k + 2] = innermin[i - 1];
                coordinates0[k + 3] = inner[i - 1][jmin + 1];
                k += 4;
            }
            if (cutoffMax) {
                coordinates0[k + 3] = outermax[i];
                coordinates0[k + 2] = outer[i][jmax];
                coordinates0[k + 1] = outer[i - 1][jmax];
                coordinates0[k] = outermax[i - 1];
                coordinates0[k += 4] = innermax[i];
                coordinates0[k + 1] = inner[i][jmax];
                coordinates0[k + 2] = inner[i - 1][jmax];
                coordinates0[k + 3] = innermax[i - 1];
                k += 4;
            }
            coordinates0[k + 3] = outermin[i];
            coordinates0[k + 2] = innermin[i];
            coordinates0[k + 1] = innermin[i - 1];
            coordinates0[k] = outermin[i - 1];
            coordinates0[k += 4] = outermax[i];
            coordinates0[k + 1] = innermax[i];
            coordinates0[k + 2] = innermax[i - 1];
            coordinates0[k + 3] = outermax[i - 1];
            k += 4;
        }
        Point3d[] coordinates = new Point3d[k];
        for (int i4 = 0; i4 < k; ++i4) {
            coordinates[i4] = coordinates0[i4];
        }
        this.addCoordinates(coordinates);
        this.setAppearance(appearance);
    }
}

