/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d;

import javax.media.j3d.Appearance;
import javax.vecmath.Point3d;
import org.freehep.j3d.Solid;

public class SphereSegment
extends Solid {
    public SphereSegment(double rmin, double rmax, double phimin, double phimax, double thetamin, double thetamax, int granularity, Appearance appearance) {
        this.construct(rmin, rmax, phimin, phimax, thetamin, thetamax, granularity, appearance);
    }

    public SphereSegment(double r, int granularity, Appearance appearance) {
        this.construct(r, 0.0, 0.0, 360.0, -90.0, 90.0, granularity, appearance);
    }

    private void construct(double rmin, double rmax, double phimin, double phimax, double thetamin, double thetamax, int granularity, Appearance appearance) {
        int i;
        int count1 = 4 * granularity;
        int count2 = 4 * granularity * granularity;
        double phimin0 = Math.toRadians(phimin);
        double phimax0 = Math.toRadians(phimax);
        double thetamin0 = Math.toRadians(thetamin);
        double thetamax0 = Math.toRadians(thetamax);
        Point3d[][] pmin = new Point3d[granularity + 1][granularity + 1];
        Point3d[][] pmax = new Point3d[granularity + 1][granularity + 1];
        Point3d[] outCoordinates = new Point3d[count2];
        Point3d[] inCoordinates = new Point3d[count2];
        Point3d[] topCoordinates = new Point3d[count1];
        Point3d[] bottomCoordinates = new Point3d[count1];
        Point3d[] leftCoordinates = new Point3d[count1];
        Point3d[] rightCoordinates = new Point3d[count1];
        double phi = phimin0;
        for (int i2 = 0; i2 < granularity + 1; ++i2) {
            double theta = thetamin0;
            for (int j = 0; j < granularity + 1; ++j) {
                pmin[i2][j] = new Point3d(rmin * Math.cos(theta) * Math.cos(phi), rmin * Math.cos(theta) * Math.sin(phi), rmin * Math.sin(theta));
                pmax[i2][j] = new Point3d(rmax * Math.cos(theta) * Math.cos(phi), rmax * Math.cos(theta) * Math.sin(phi), rmax * Math.sin(theta));
                theta += (thetamax0 - thetamin0) / (double)granularity;
            }
            phi += (phimax0 - phimin0) / (double)granularity;
        }
        int k = 0;
        for (i = 0; i < granularity; ++i) {
            for (int j = 0; j < granularity; ++j) {
                outCoordinates[k] = new Point3d(pmax[i][j]);
                outCoordinates[k + 1] = new Point3d(pmax[i + 1][j]);
                outCoordinates[k + 2] = new Point3d(pmax[i + 1][j + 1]);
                outCoordinates[k + 3] = new Point3d(pmax[i][j + 1]);
                if (rmin > 0.0) {
                    inCoordinates[k + 3] = new Point3d(pmin[i][j]);
                    inCoordinates[k + 2] = new Point3d(pmin[i + 1][j]);
                    inCoordinates[k + 1] = new Point3d(pmin[i + 1][j + 1]);
                    inCoordinates[k] = new Point3d(pmin[i][j + 1]);
                }
                k += 4;
            }
        }
        k = 0;
        for (i = 0; i < granularity; ++i) {
            if (thetamax < 90.0) {
                topCoordinates[k + 3] = new Point3d(pmax[i][0]);
                topCoordinates[k + 2] = new Point3d(pmax[i + 1][0]);
                topCoordinates[k + 1] = new Point3d(pmin[i + 1][0]);
                topCoordinates[k] = new Point3d(pmin[i][0]);
            }
            if (thetamin > -90.0) {
                bottomCoordinates[k] = new Point3d(pmax[i][granularity]);
                bottomCoordinates[k + 1] = new Point3d(pmax[i + 1][granularity]);
                bottomCoordinates[k + 2] = new Point3d(pmin[i + 1][granularity]);
                bottomCoordinates[k + 3] = new Point3d(pmin[i][granularity]);
            }
            if (phimin > 0.0 || phimax < 360.0) {
                leftCoordinates[k] = new Point3d(pmax[0][i]);
                leftCoordinates[k + 1] = new Point3d(pmax[0][i + 1]);
                leftCoordinates[k + 2] = new Point3d(pmin[0][i + 1]);
                leftCoordinates[k + 3] = new Point3d(pmin[0][i]);
                rightCoordinates[k + 3] = new Point3d(pmax[granularity][i]);
                rightCoordinates[k + 2] = new Point3d(pmax[granularity][i + 1]);
                rightCoordinates[k + 1] = new Point3d(pmin[granularity][i + 1]);
                rightCoordinates[k] = new Point3d(pmin[granularity][i]);
            }
            k += 4;
        }
        this.addCoordinates(outCoordinates);
        if (rmin > 0.0) {
            this.addCoordinates(inCoordinates);
        }
        if (thetamax < 90.0) {
            this.addCoordinates(topCoordinates);
        }
        if (thetamin > -90.0) {
            this.addCoordinates(bottomCoordinates);
        }
        if (phimin > 0.0 || phimax < 360.0) {
            this.addCoordinates(leftCoordinates);
            this.addCoordinates(rightCoordinates);
        }
        this.setAppearance(appearance);
    }
}

