/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d;

import javax.media.j3d.Appearance;
import javax.vecmath.Point3d;
import org.freehep.j3d.Solid;

public class TorusSegment
extends Solid {
    public TorusSegment(double rmin, double rmax, double rtor, double phimin, double phimax, int granularity, Appearance appearance) {
        this.construct(rmin, rmax, rtor, phimin, phimax, granularity, appearance);
    }

    public TorusSegment(double r, double rtor, int granularity, Appearance appearance) {
        this.construct(r, r, rtor, 0.0, 360.0, granularity, appearance);
    }

    private void construct(double rmin, double rmax, double rtor, double phimin, double phimax, int granularity, Appearance appearance) {
        int j1;
        int count1 = 4 * granularity;
        int count2 = phimin == 0.0 && phimax == 360.0 ? 4 * granularity * granularity : 4 * granularity * (granularity - 1);
        double phimin0 = Math.toRadians(phimin);
        double phimax0 = Math.toRadians(phimax);
        Point3d[][] pmin = new Point3d[granularity][granularity];
        Point3d[][] pmax = new Point3d[granularity][granularity];
        Point3d[] outCoordinates = new Point3d[count2];
        Point3d[] inCoordinates = new Point3d[count2];
        Point3d[] topCoordinates = new Point3d[count1];
        Point3d[] bottomCoordinates = new Point3d[count1];
        double phi = phimin0;
        for (int i = 0; i < granularity; ++i) {
            double psi = 0.0;
            for (int j = 0; j < granularity; ++j) {
                pmin[i][j] = new Point3d((rtor + rmin * Math.cos(psi)) * Math.cos(phi), (rtor + rmin * Math.cos(psi)) * Math.sin(phi), rmin * Math.sin(psi));
                pmax[i][j] = new Point3d((rtor + rmax * Math.cos(psi)) * Math.cos(phi), (rtor + rmax * Math.cos(psi)) * Math.sin(phi), rmax * Math.sin(psi));
                psi += Math.PI * 2 / (double)granularity;
            }
            phi += (phimax0 - phimin0) / (double)granularity;
        }
        int k = 0;
        for (int i = 0; i < granularity; ++i) {
            if (i == granularity - 1 && (phimin != 0.0 || phimax != 360.0)) continue;
            int i1 = i == granularity - 1 ? 0 : i + 1;
            for (int j = 0; j < granularity; ++j) {
                j1 = j == granularity - 1 ? 0 : j + 1;
                outCoordinates[k] = new Point3d(pmax[i][j]);
                outCoordinates[k + 1] = new Point3d(pmax[i1][j]);
                outCoordinates[k + 2] = new Point3d(pmax[i1][j1]);
                outCoordinates[k + 3] = new Point3d(pmax[i][j1]);
                if (rmin > 0.0) {
                    inCoordinates[k + 3] = new Point3d(pmin[i][j]);
                    inCoordinates[k + 2] = new Point3d(pmin[i1][j]);
                    inCoordinates[k + 1] = new Point3d(pmin[i1][j1]);
                    inCoordinates[k] = new Point3d(pmin[i][j1]);
                }
                k += 4;
            }
        }
        if (phimin != 0.0 || phimax != 360.0) {
            k = 0;
            for (int j = 0; j < granularity; ++j) {
                j1 = j == granularity - 1 ? 0 : j + 1;
                topCoordinates[k] = new Point3d(pmin[0][j]);
                topCoordinates[k + 1] = new Point3d(pmax[0][j]);
                topCoordinates[k + 2] = new Point3d(pmax[0][j1]);
                topCoordinates[k + 3] = new Point3d(pmin[0][j1]);
                bottomCoordinates[k + 3] = new Point3d(pmin[granularity - 1][j]);
                bottomCoordinates[k + 2] = new Point3d(pmax[granularity - 1][j]);
                bottomCoordinates[k + 1] = new Point3d(pmax[granularity - 1][j1]);
                bottomCoordinates[k] = new Point3d(pmin[granularity - 1][j1]);
                k += 4;
            }
        }
        this.addCoordinates(outCoordinates);
        if (rmin > 0.0) {
            this.addCoordinates(inCoordinates);
        }
        if (phimin != 0.0 || phimax != 360.0) {
            this.addCoordinates(topCoordinates);
            this.addCoordinates(bottomCoordinates);
        }
        this.setAppearance(appearance);
    }
}

