/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d;

import javax.media.j3d.Appearance;
import javax.vecmath.Point3d;
import org.freehep.j3d.Solid;

public class Trapezoid
extends Solid {
    public Trapezoid(double xmu, double xmd, double xpu, double xpd, double ym, double yp, double z, double inclXZ, double inclYZ, double declYm, double declYp, Appearance appearance) {
        this.construct(xmu, xmd, xpu, xpd, ym, yp, z, inclXZ, inclYZ, declYm, declYp, appearance);
    }

    public Trapezoid(double xm, double xp, double ym, double yp, double z, double inclXZ, double inclYZ, Appearance appearance) {
        this.construct(xm, xm, xp, xp, ym, yp, z, inclXZ, inclYZ, 0.0, 0.0, appearance);
    }

    public Trapezoid(double xm, double xp, double ym, double yp, double z, Appearance appearance) {
        this.construct(xm, xm, xp, xp, ym, yp, z, 0.0, 0.0, 0.0, 0.0, appearance);
    }

    public Trapezoid(double x, double y, double z, Appearance appearance) {
        this.construct(x, x, x, x, y, y, z, 0.0, 0.0, 0.0, 0.0, appearance);
    }

    private void construct(double xmu, double xmd, double xpu, double xpd, double ym, double yp, double z, double inclXZ, double inclYZ, double declYm, double declYp, Appearance appearance) {
        double delX = z / 2.0 * Math.tan(Math.toRadians(inclXZ));
        double delY = z / 2.0 * Math.tan(Math.toRadians(inclYZ));
        double delZm = ym / 2.0 * Math.tan(Math.toRadians(declYm));
        double delZp = yp / 2.0 * Math.tan(Math.toRadians(declYp));
        Point3d t00 = new Point3d(-xmu / 2.0 - delX + delZm, ym / 2.0 - delY, -z / 2.0);
        Point3d t01 = new Point3d(xmu / 2.0 - delX + delZm, ym / 2.0 - delY, -z / 2.0);
        Point3d t10 = new Point3d(xmd / 2.0 - delX - delZm, -ym / 2.0 - delY, -z / 2.0);
        Point3d t11 = new Point3d(-xmd / 2.0 - delX - delZm, -ym / 2.0 - delY, -z / 2.0);
        Point3d b00 = new Point3d(-xpu / 2.0 + delX + delZp, yp / 2.0 + delY, z / 2.0);
        Point3d b01 = new Point3d(xpu / 2.0 + delX + delZp, yp / 2.0 + delY, z / 2.0);
        Point3d b10 = new Point3d(xpd / 2.0 + delX - delZp, -yp / 2.0 + delY, z / 2.0);
        Point3d b11 = new Point3d(-xpd / 2.0 + delX - delZp, -yp / 2.0 + delY, z / 2.0);
        Point3d[] coordinates = new Point3d[]{t00, b00, b01, t01, t01, b01, b10, t10, t10, b10, b11, t11, t11, b11, b00, t00, t00, t01, t10, t11, b11, b10, b01, b00};
        this.addCoordinates(coordinates);
        this.setAppearance(appearance);
    }
}

