/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import java.awt.Font;
import javax.media.j3d.Billboard;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import org.freehep.j3d.plot.AxisLabelCalculator;

public class AxisBuilder {
    private String labelText;
    private Font3D labelFont = defaultLabelFont;
    private double[] tickLocations;
    private String[] tickLabels;
    private Font3D tickFont = defaultTickFont;
    private TransformGroup mainGroup;
    private Text3D label = new Text3D();
    private Shape3D axis;
    private BranchGroup ticks;
    protected static float scale = 256.0f;
    protected static float major = 0.02f * scale;
    protected static float minor = 0.01f * scale;
    protected static float tickOffSet = 0.06f * scale;
    protected static float labelOffSet = 0.12f * scale;
    private static final Font3D defaultLabelFont = new Font3D(new Font("DIALOG", 1, 16), null);
    private static final Font3D defaultTickFont = new Font3D(new Font("DIALOG", 0, 12), null);
    private static Color3f white = new Color3f(1.0f, 1.0f, 1.0f);

    AxisBuilder() {
        this.label.setAlignment(0);
        Point3f pos = new Point3f(scale / 2.0f, -labelOffSet, 0.0f);
        this.label.setPosition(pos);
        this.label.setCapability(1);
        this.label.setCapability(3);
        this.axis = new Shape3D();
        this.axis.setCapability(13);
        this.ticks = new BranchGroup();
        this.ticks.setCapability(12);
        this.ticks.setCapability(13);
        this.ticks.setCapability(17);
        this.mainGroup = new TransformGroup();
        this.mainGroup.setCapability(13);
        this.mainGroup.setCapability(14);
        this.mainGroup.addChild((Node)new Shape3D((Geometry)this.label));
        this.mainGroup.addChild((Node)this.axis);
        this.mainGroup.addChild((Node)this.ticks);
        this.mainGroup.setCapability(18);
        this.mainGroup.setCapability(17);
        Billboard bboard = new Billboard(this.mainGroup);
        this.mainGroup.addChild((Node)bboard);
        bboard.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 10.0));
        bboard.setAlignmentAxis(1.0f, 0.0f, 0.0f);
    }

    public String getLabel() {
        return this.labelText;
    }

    public void setLabel(String label) {
        this.labelText = label;
    }

    public Font3D getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font3D font) {
        this.labelFont = font;
    }

    public Font3D getTickFont() {
        return this.tickFont;
    }

    public void setTickFont(Font3D font) {
        this.tickFont = font;
    }

    public double[] getTickLocations() {
        return this.tickLocations;
    }

    public void setTickLocations(double[] ticks) {
        this.tickLocations = ticks;
    }

    public String[] getTickLabels() {
        return this.tickLabels;
    }

    public void setTickLabels(String[] labels) {
        this.tickLabels = labels;
    }

    public void createLabelsNTicks(double min, double max) {
        AxisLabelCalculator axisCalc = new AxisLabelCalculator();
        axisCalc.createNewLabels(min, max);
        this.tickLabels = axisCalc.getLabels();
        this.tickLocations = axisCalc.getPositions();
    }

    public void apply() {
        int tMajor = (this.tickLocations.length - 1) / (this.tickLabels.length - 1);
        LineArray lines = new LineArray(2 * this.tickLocations.length + 2, 1);
        int coordIdx = 0;
        lines.setCoordinate(coordIdx++, new Point3d(0.0, 0.0, 0.0));
        lines.setCoordinate(coordIdx++, new Point3d((double)scale, 0.0, 0.0));
        this.ticks.detach();
        this.ticks = new BranchGroup();
        this.ticks.setCapability(12);
        this.ticks.setCapability(13);
        this.ticks.setCapability(17);
        for (int i = 0; i < this.tickLocations.length; ++i) {
            float x = (float)this.tickLocations[i] * scale;
            if (i % tMajor == 0) {
                lines.setCoordinate(coordIdx++, new Point3d((double)x, 0.0, 0.0));
                lines.setCoordinate(coordIdx++, new Point3d((double)x, (double)(-major), 0.0));
                int nt = i / tMajor;
                Point3f pos = new Point3f(x, -tickOffSet, 0.0f);
                Text3D tickLabel = new Text3D(this.tickFont, this.tickLabels[nt], pos);
                tickLabel.setAlignment(0);
                this.ticks.addChild((Node)new Shape3D((Geometry)tickLabel));
                continue;
            }
            lines.setCoordinate(coordIdx++, new Point3d((double)x, 0.0, 0.0));
            lines.setCoordinate(coordIdx++, new Point3d((double)x, (double)(-minor), 0.0));
        }
        this.mainGroup.addChild((Node)this.ticks);
        this.label.setFont3D(this.labelFont);
        this.label.setString(this.labelText);
        this.axis.setGeometry((Geometry)lines);
    }

    public Node getNode() {
        return this.mainGroup;
    }
}

