/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import org.freehep.j3d.plot.DoubleNumberFormatter;

public class AxisLabelCalculator {
    private double data_min = 0.0;
    private double data_max = 1.0;
    private double plot_min = 0.0;
    private double plot_max = 1.0;
    private AxisLabel[] labels;
    private int nDivisions = 0;
    private boolean labelsValid;

    public void createNewLabels(double min, double max) {
        double inc;
        this.data_min = min;
        this.data_max = max;
        int minNumberOfDivisions = 1;
        int maxNumberOfDivisions = 10;
        double log10 = Math.log(10.0);
        int maxCharsPerLabel = 5;
        this.labelsValid = true;
        double log_max = this.data_max == 0.0 ? 0.0 : Math.log(Math.abs(this.data_max)) / log10;
        int int_log_max = (int)Math.floor(log_max);
        int scale_power = 0;
        if (int_log_max >= maxCharsPerLabel) {
            scale_power = int_log_max;
        } else if (int_log_max <= -maxCharsPerLabel) {
            scale_power = int_log_max;
        }
        DoubleNumberFormatter format = new DoubleNumberFormatter(scale_power);
        double difference = this.data_max - this.data_min;
        double pow = Math.floor(Math.log(difference) / log10) - 1.0;
        int fractDigits = 0;
        if (scale_power > 0) {
            fractDigits = scale_power - (int)pow;
        } else if (pow < -0.5) {
            fractDigits = scale_power - (int)pow;
        }
        double conversion = Math.pow(10.0, pow);
        int intMin = this.round(this.data_min / conversion, false);
        int intMax = this.round(this.data_max / conversion, true);
        this.plot_min = this.data_min;
        this.plot_max = this.data_max;
        int naturalNumberOfDivisions = intMax - intMin;
        int nDivisions = 0;
        float idealMinFraction = 0.5f;
        int nUnits = 1;
        if (naturalNumberOfDivisions < maxNumberOfDivisions) {
            float proximity = (float)naturalNumberOfDivisions / (float)maxNumberOfDivisions;
            boolean niceDivisionFound = false;
            if (proximity < 0.5f) {
                int candidate;
                int[] divisions = new int[]{2, 4, 5, 10, 20};
                for (int i = 0; i < divisions.length && (double)(proximity * (float)(candidate = divisions[i])) <= 1.0; ++i) {
                    niceDivisionFound = true;
                    nUnits = candidate;
                }
            }
            if (niceDivisionFound) {
                nDivisions = naturalNumberOfDivisions * nUnits + (int)((this.plot_max / conversion - (double)intMax) * (double)nUnits);
                if (pow < 0.5 || scale_power > 0) {
                    ++fractDigits;
                }
                if (!(nUnits != 4 && nUnits != 20 || !(pow < 1.5) && scale_power <= 0)) {
                    ++fractDigits;
                }
            } else {
                nDivisions = Math.max(naturalNumberOfDivisions, minNumberOfDivisions);
            }
        } else if (naturalNumberOfDivisions > maxNumberOfDivisions) {
            nDivisions = 1;
            int[] skips = new int[]{2, 5, 10, 20, 25, 50};
            for (int i = 0; i < skips.length; ++i) {
                int nDivisionsThisTry = naturalNumberOfDivisions / skips[i];
                if (nDivisionsThisTry > maxNumberOfDivisions) continue;
                nUnits = skips[i];
                nDivisions = nDivisionsThisTry;
                if (nUnits >= 10 && nUnits != 25 && fractDigits > 0) {
                    --fractDigits;
                }
                if (intMin % nUnits != 0) {
                    int increase;
                    int n = increase = intMin > 0 ? nUnits - intMin % nUnits : -intMin % nUnits;
                    if (increase > intMax - (intMax - intMin) / nUnits * nUnits - intMin) {
                        --nDivisions;
                    }
                    intMin += increase;
                }
                break;
            }
        } else {
            nDivisions = Math.max(naturalNumberOfDivisions, minNumberOfDivisions);
        }
        double minLabelValue = (double)intMin * conversion;
        double d = inc = naturalNumberOfDivisions < maxNumberOfDivisions ? conversion / (double)nUnits : conversion * (double)nUnits;
        if (naturalNumberOfDivisions < maxNumberOfDivisions && minLabelValue - inc >= this.plot_min) {
            int nLost = (int)((minLabelValue - inc) / inc);
            minLabelValue -= (double)nLost * inc;
            nDivisions += nLost;
        }
        this.labels = new AxisLabel[nDivisions + 1];
        this.nDivisions = nDivisions;
        format.setFractionDigits(fractDigits);
        for (int j = 0; j < this.labels.length; ++j) {
            double labelValue = minLabelValue + (double)j * inc;
            this.labels[j] = new AxisLabel();
            this.labels[j].text = format.format(labelValue);
            this.labels[j].position = (labelValue - this.plot_min) / (this.plot_max - this.plot_min);
            if (!(this.labels[j].position < 0.0)) continue;
            this.labels[j].position = 0.0;
        }
    }

    private int charsReq(int pow) {
        if (pow < 0) {
            return -pow + 2;
        }
        return pow + 1;
    }

    private int round(double d, boolean down) {
        block3: {
            double round;
            block2: {
                double minProximity = 1.0E-4;
                round = Math.round(d);
                if (d == round) break block2;
                double d2 = Math.abs(d - round);
                double d3 = d != 0.0 ? 1.0E-4 * Math.abs(d) : 1.0E-6;
                if (!(d2 < d3)) break block3;
            }
            return (int)round;
        }
        return down ? (int)Math.floor(d) : (int)Math.ceil(d);
    }

    public String[] getLabels() {
        int len = this.labels.length;
        String[] lab = new String[len];
        for (int i = 0; i < len; ++i) {
            lab[i] = this.labels[i].text;
        }
        return lab;
    }

    public double[] getPositions() {
        int len = this.labels.length;
        double[] pos = new double[len];
        for (int i = 0; i < len; ++i) {
            pos[i] = this.labels[i].position;
        }
        return pos;
    }

    public void printLabels() {
        System.out.println("data_min = " + this.data_min + ", data_max = " + this.data_max);
        System.out.println("plot_min = " + this.plot_min + ", plot_max = " + this.plot_max);
        System.out.println("nDivisions = " + this.nDivisions + ", labelsValid = " + this.labelsValid);
        for (int i = 0; i < this.labels.length; ++i) {
            System.out.println("label " + (i + 1) + ": " + this.labels[i].text + "  position: " + this.labels[i].position);
        }
    }

    public static void main(String[] argv) {
        AxisLabelCalculator t = new AxisLabelCalculator();
        t.createNewLabels(0.0, 1.0);
        t.printLabels();
        t.createNewLabels(0.0, 100.0);
        t.printLabels();
        t.createNewLabels(1.0E-4, 0.001);
        t.printLabels();
        t.createNewLabels(5.0, 10.0);
        t.printLabels();
        t.createNewLabels(0.001, 0.05);
        t.printLabels();
        t.createNewLabels(1.0E-5, 5.0E-5);
        t.printLabels();
        t.createNewLabels(-0.001, 5.0E-5);
        t.printLabels();
        t.createNewLabels(-0.001, 0.005);
        t.printLabels();
        t.createNewLabels(-2.0, 5.0);
        t.printLabels();
        t.createNewLabels(0.05, 10.0);
        t.printLabels();
    }

    private class AxisLabel {
        String text;
        double position;

        private AxisLabel() {
        }
    }
}

