/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOr;
import org.freehep.j3d.plot.KeyNavigator;

public class KeyNavigatorBehavior
extends Behavior {
    private WakeupOnAWTEvent w1 = new WakeupOnAWTEvent(401);
    private WakeupOnAWTEvent w2 = new WakeupOnAWTEvent(402);
    private WakeupOnElapsedFrames w3 = new WakeupOnElapsedFrames(1);
    private WakeupCriterion[] warray = new WakeupCriterion[]{this.w1, this.w2, this.w3};
    private WakeupCondition w = new WakeupOr(this.warray);
    private KeyEvent eventKey;
    private KeyNavigator keyNavigator;

    public void initialize() {
        this.wakeupOn(this.w);
    }

    public void processStimulus(Enumeration criteria) {
        boolean sawFrame = false;
        while (criteria.hasMoreElements()) {
            WakeupCriterion genericEvt = (WakeupCriterion)criteria.nextElement();
            if (genericEvt instanceof WakeupOnAWTEvent) {
                WakeupOnAWTEvent ev = (WakeupOnAWTEvent)genericEvt;
                AWTEvent[] events = ev.getAWTEvent();
                this.processAWTEvent(events);
                continue;
            }
            if (!(genericEvt instanceof WakeupOnElapsedFrames) || this.eventKey == null) continue;
            sawFrame = true;
        }
        if (sawFrame) {
            this.keyNavigator.integrateTransformChanges();
        }
        this.wakeupOn(this.w);
    }

    private void processAWTEvent(AWTEvent[] events) {
        for (int loop = 0; loop < events.length; ++loop) {
            if (!(events[loop] instanceof KeyEvent)) continue;
            this.eventKey = (KeyEvent)events[loop];
            if (this.eventKey.getID() != 401 && this.eventKey.getID() != 402) continue;
            this.keyNavigator.processKeyEvent(this.eventKey);
        }
    }

    public KeyNavigatorBehavior(TransformGroup targetTG) {
        this.keyNavigator = new KeyNavigator(targetTG);
    }
}

