/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.freehep.j3d.plot.AbstractPlotBuilder;
import org.freehep.j3d.plot.NormalizedBinned2DData;
import org.freehep.j3d.plot.Rainbow;
import org.freehep.j3d.plot.TimeStamp;

public class LegoBuilder
extends AbstractPlotBuilder {
    private static final Color3b grey = new Color3b(50, 50, 50);
    private static final Rainbow rainbow = new Rainbow();
    private static final Vector3f xnormal = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f xabnormal = new Vector3f(-1.0f, 0.0f, 0.0f);
    private static final Vector3f ynormal = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f yabnormal = new Vector3f(0.0f, -1.0f, 0.0f);
    private static final Vector3f znormal = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Vector3f zabnormal = new Vector3f(0.0f, 0.0f, -1.0f);
    private static final int fullPlotChild = 0;
    private static final int sparsePlotChild = 1;
    private TimeStamp timeStamp = TimeStamp.sharedInstance();
    private boolean drawBlocks = true;
    private boolean linesWhileAnim = true;
    private int numWireLines = 600;
    private int bcur;
    private QuadArray quad;
    private LineArray line;
    private Shape3D shape;
    private Shape3D lineShape;
    private Switch targetSwitch;
    private int popBins = 0;
    private boolean shapeIsLego = false;

    public Node buildContent(NormalizedBinned2DData data) {
        this.targetSwitch = new Switch();
        this.targetSwitch.setCapability(18);
        if (this.drawBlocks) {
            this.shape = this.createShape();
            this.shapeIsLego = true;
            this.shape.setCapability(13);
            this.shape.setCapability(15);
            this.shape.setGeometry(this.buildGeometry(data));
        } else {
            this.shape = this.createLineShape();
            this.shapeIsLego = false;
            this.shape.setCapability(13);
            this.popBins = this.calcPopBins(data);
            int[] binInc = new int[]{1, 1};
            this.shape.setGeometry(this.buildWireGeometry(data, binInc));
        }
        this.lineShape = this.createLineShape();
        this.lineShape.setCapability(13);
        this.targetSwitch.addChild((Node)this.shape);
        this.targetSwitch.addChild((Node)this.lineShape);
        if (this.linesWhileAnim && (this.shapeIsLego || this.popBins > this.numWireLines / 2)) {
            this.lineShape.setGeometry(this.buildWireGeometry(data));
            this.targetSwitch.setUserData((Object)Boolean.TRUE);
        } else {
            this.targetSwitch.setUserData((Object)Boolean.FALSE);
        }
        this.targetSwitch.setWhichChild(0);
        return this.targetSwitch;
    }

    public void updatePlot(NormalizedBinned2DData data) {
        if (this.drawBlocks) {
            if (!this.shapeIsLego) {
                this.shape.setAppearance(this.createMaterialAppearance());
                this.shapeIsLego = true;
            }
            this.shape.setGeometry(this.buildGeometry(data));
        } else {
            this.popBins = this.calcPopBins(data);
            int[] binInc = new int[]{1, 1};
            if (this.shapeIsLego) {
                this.shape.setAppearance(this.createWireFrameAppearance());
                this.shapeIsLego = false;
            }
            this.shape.setGeometry(this.buildWireGeometry(data, binInc));
        }
        if (this.linesWhileAnim && (this.shapeIsLego || this.popBins > this.numWireLines / 2)) {
            this.lineShape.setGeometry(this.buildWireGeometry(data));
            this.targetSwitch.setUserData((Object)Boolean.TRUE);
        } else {
            this.targetSwitch.setUserData((Object)Boolean.FALSE);
        }
    }

    public int getNumWireLines() {
        return this.numWireLines;
    }

    public void setNumWireLines(int val) {
        this.numWireLines = val;
    }

    public boolean getDrawBlocks() {
        return this.drawBlocks;
    }

    public void setDrawBlocks(boolean b) {
        this.drawBlocks = b;
    }

    public boolean getLinesWhileAnim() {
        return this.linesWhileAnim;
    }

    public void setLinesWhileAnim(boolean b) {
        this.linesWhileAnim = b;
    }

    private Geometry buildGeometry(NormalizedBinned2DData data) {
        this.timeStamp.print("Starting LegoBuilder.buildContent()");
        int nXbins = data.xBins();
        int nYbins = data.yBins();
        this.bcur = 0;
        int maxpoints = (nXbins + 1) * (nYbins + 1) * 4 * 3 * 4;
        this.quad = new QuadArray(maxpoints, 7);
        this.drawXYrect(-0.5f, -0.5f, 0.0f, 0.5f, 0.5f, 0.0f, grey, znormal);
        float xBinWidth = 1.0f / (float)nXbins;
        float yBinWidth = 1.0f / (float)nYbins;
        float x = -xBinWidth - 0.5f;
        float xBinWAdj = 1.0f / (float)nXbins / 100.0f;
        float yBinWAdj = 1.0f / (float)nYbins / 100.0f;
        this.popBins = 0;
        int k = -1;
        while (k < nXbins) {
            float y = -yBinWidth - 0.5f;
            int l = -1;
            while (l < nYbins) {
                float z = data.zAt(k, l);
                Color3b curColor = data.colorAt(k, l);
                if (z != 0.0f) {
                    ++this.popBins;
                    this.drawXYrect(x + xBinWidth - xBinWAdj, y + yBinWidth - yBinWAdj, z, x, y, z, curColor, znormal);
                    this.drawXYrect(x + xBinWidth - xBinWAdj, y + yBinWidth - yBinWAdj, 0.001f, x, y, 0.001f, curColor, znormal);
                }
                float nextZ = data.zAt(k, l + 1);
                Color3b nextColor = data.colorAt(k, l + 1);
                if (z != 0.0f) {
                    this.drawXZrect(x, y + yBinWidth - yBinWAdj / 2.0f, z, x + xBinWidth - xBinWAdj, y + yBinWidth - yBinWAdj / 2.0f, 0.0f, curColor, ynormal);
                    this.drawXZrect(x, y + yBinWidth - yBinWAdj, z, x + xBinWidth - xBinWAdj, y + yBinWidth - yBinWAdj, 0.0f, curColor, yabnormal);
                }
                if (nextZ != 0.0f) {
                    this.drawXZrect(x, y + yBinWidth, 0.0f, x + xBinWidth, y + yBinWidth, nextZ, nextColor, yabnormal);
                    this.drawXZrect(x, y + yBinWidth + yBinWAdj, 0.0f, x + xBinWidth, y + yBinWidth + yBinWAdj, nextZ, nextColor, ynormal);
                }
                nextZ = data.zAt(k + 1, l);
                nextColor = data.colorAt(k + 1, l);
                if (z != 0.0f) {
                    this.drawYZrect(x + xBinWidth - xBinWAdj / 2.0f, y, z, x + xBinWidth - xBinWAdj / 2.0f, y + yBinWidth - yBinWAdj, 0.0f, curColor, xnormal);
                    this.drawYZrect(x + xBinWidth - xBinWAdj, y, z, x + xBinWidth - xBinWAdj, y + yBinWidth - yBinWAdj, 0.0f, curColor, xabnormal);
                }
                if (nextZ != 0.0f) {
                    this.drawYZrect(x + xBinWidth, y, 0.0f, x + xBinWidth, y + yBinWidth, nextZ, nextColor, xabnormal);
                    this.drawYZrect(x + xBinWidth + xBinWAdj, y, 0.0f, x + xBinWidth + xBinWAdj, y + yBinWidth, nextZ, nextColor, xnormal);
                }
                ++l;
                y += yBinWidth;
            }
            ++k;
            x += xBinWidth;
        }
        this.timeStamp.print("finished, now finalizing, point count = " + this.bcur);
        return this.quad;
    }

    private Geometry buildWireGeometry(NormalizedBinned2DData data) {
        int[] wireBinInc = this.calcXYfactors(data.xBins(), data.yBins());
        return this.buildWireGeometry(data, wireBinInc);
    }

    private Geometry buildWireGeometry(NormalizedBinned2DData data, int[] wireBinInc) {
        this.timeStamp.print("Starting LegoBuilder.buildWireGeometry()");
        int nXbins = data.xBins();
        int nYbins = data.yBins();
        this.bcur = 0;
        int maxpoints = (nXbins / wireBinInc[0] + 1) * (nYbins / wireBinInc[1] + 1) * 3 * 2 + 8;
        this.line = new LineArray(maxpoints, 7);
        float xBinWidth = (float)wireBinInc[0] / (float)nXbins;
        float yBinWidth = (float)wireBinInc[1] / (float)nYbins;
        float x = -0.5f;
        int k = 0;
        while (k < nXbins) {
            float y = -0.5f;
            int l = 0;
            while (l < nYbins) {
                float z = data.zAt(k, l);
                Color3b curColor = data.colorAt(k, l);
                if (z != 0.0f) {
                    this.drawVLine(x + xBinWidth / 2.0f, y + yBinWidth / 2.0f, 0.0f, z, curColor, xnormal);
                }
                l += wireBinInc[1];
                y += yBinWidth;
            }
            k += wireBinInc[0];
            x += xBinWidth;
        }
        this.timeStamp.print("finished, now finalizing, point count = " + this.bcur);
        return this.line;
    }

    Shape3D createLineShape() {
        Shape3D lineShape = new Shape3D();
        this.timeStamp.print("line geometry set");
        lineShape.setAppearance(this.createWireFrameAppearance());
        return lineShape;
    }

    Appearance createWireFrameAppearance() {
        Appearance materialAppear = new Appearance();
        LineAttributes lineAttrib = new LineAttributes();
        materialAppear.setLineAttributes(lineAttrib);
        ColoringAttributes redColoring = new ColoringAttributes();
        redColoring.setColor(1.0f, 0.0f, 0.0f);
        materialAppear.setColoringAttributes(redColoring);
        return materialAppear;
    }

    Shape3D createShape() {
        Shape3D surface = new Shape3D();
        this.timeStamp.print("geometry set");
        surface.setAppearance(this.createMaterialAppearance());
        return surface;
    }

    private Appearance createMaterialAppearance() {
        Appearance materialAppear = new Appearance();
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCullFace(0);
        materialAppear.setPolygonAttributes(polyAttrib);
        Material material = new Material();
        material.setDiffuseColor(new Color3f(1.0f, 0.0f, 0.0f));
        materialAppear.setMaterial(material);
        return materialAppear;
    }

    private void drawLine(float x1, float y1, float z1, float x2, float y2, float z2, Color3b lineColor, Vector3f normal) {
        this.line.setCoordinate(this.bcur, new Point3f(x1, y1, z1));
        this.line.setColor(this.bcur, lineColor);
        this.line.setNormal(this.bcur, normal);
        ++this.bcur;
        this.line.setCoordinate(this.bcur, new Point3f(x2, y2, z2));
        this.line.setColor(this.bcur, lineColor);
        this.line.setNormal(this.bcur, normal);
        ++this.bcur;
    }

    private void drawVLine(float x, float y, float z1, float z2, Color3b lineColor, Vector3f normal) {
        this.line.setCoordinate(this.bcur, new Point3f(x, y, z1));
        this.line.setColor(this.bcur, lineColor);
        this.line.setNormal(this.bcur, normal);
        ++this.bcur;
        this.line.setCoordinate(this.bcur, new Point3f(x, y, z2));
        this.line.setColor(this.bcur, lineColor);
        this.line.setNormal(this.bcur, normal);
        ++this.bcur;
    }

    private void drawXYrect(float x1, float y1, float z1, float x2, float y2, float z2, Color3b rectColor, Vector3f normal) {
        this.quad.setCoordinate(this.bcur, new Point3f(x1, y1, z1));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
        this.quad.setCoordinate(this.bcur, new Point3f(x1, y2, z1));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
        this.quad.setCoordinate(this.bcur, new Point3f(x2, y2, z1));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
        this.quad.setCoordinate(this.bcur, new Point3f(x2, y1, z1));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
    }

    private void drawXZrect(float x1, float y1, float z1, float x2, float y2, float z2, Color3b rectColor, Vector3f normal) {
        this.quad.setCoordinate(this.bcur, new Point3f(x1, y1, z1));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
        this.quad.setCoordinate(this.bcur, new Point3f(x2, y1, z1));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
        this.quad.setCoordinate(this.bcur, new Point3f(x2, y1, z2));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
        this.quad.setCoordinate(this.bcur, new Point3f(x1, y1, z2));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
    }

    private void drawYZrect(float x1, float y1, float z1, float x2, float y2, float z2, Color3b rectColor, Vector3f normal) {
        this.quad.setCoordinate(this.bcur, new Point3f(x1, y1, z1));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
        this.quad.setCoordinate(this.bcur, new Point3f(x1, y2, z1));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
        this.quad.setCoordinate(this.bcur, new Point3f(x1, y2, z2));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
        this.quad.setCoordinate(this.bcur, new Point3f(x1, y1, z2));
        this.quad.setColor(this.bcur, rectColor);
        this.quad.setNormal(this.bcur, normal);
        ++this.bcur;
    }

    private int[] calcXYfactors(int nXbins, int nYbins) {
        int[] binInc = new int[]{1, 1};
        if (nXbins * nYbins > this.numWireLines) {
            double xyBinRatio = (double)nXbins / (double)nYbins;
            binInc[0] = (int)((double)nXbins / (Math.sqrt(this.numWireLines) / xyBinRatio));
            binInc[1] = (int)((double)nYbins / (Math.sqrt(this.numWireLines) * xyBinRatio));
            if (binInc[0] < 1) {
                binInc[0] = 1;
            }
            if (binInc[1] < 1) {
                binInc[1] = 1;
            }
        }
        return binInc;
    }

    private int calcPopBins(NormalizedBinned2DData data) {
        int nXbins = data.xBins();
        int nYbins = data.yBins();
        int numPopBins = 0;
        float x = -1.0f / (float)nXbins - 0.5f;
        int k = -1;
        while (k < nXbins) {
            float y = -1.0f / (float)nYbins - 0.5f;
            int l = -1;
            while (l < nYbins) {
                float z = data.zAt(k, l);
                if (z != 0.0f) {
                    ++numPopBins;
                }
                ++l;
                y += 1.0f / (float)nYbins;
            }
            ++k;
            x += 1.0f / (float)nXbins;
        }
        return numPopBins;
    }
}

