/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import javax.vecmath.Color3b;
import org.freehep.j3d.plot.Binned2DData;

class NormalizedBinned2DData {
    private int xBins;
    private int yBins;
    private float[][] data;
    private Color3b[][] color;

    NormalizedBinned2DData(Binned2DData in) {
        this.initialize(in);
    }

    void initialize(Binned2DData in) {
        float z;
        int j;
        int i;
        this.xBins = in.xBins();
        this.yBins = in.yBins();
        this.data = new float[this.xBins][this.yBins];
        this.color = new Color3b[this.xBins][this.yBins];
        float zMin = Float.MAX_VALUE;
        float zMax = -3.4028235E38f;
        for (i = 0; i < this.xBins; ++i) {
            for (j = 0; j < this.yBins; ++j) {
                z = in.zAt(i, j);
                if (z < zMin) {
                    zMin = z;
                }
                if (z > zMax) {
                    zMax = z;
                }
                this.data[i][j] = z;
                this.color[i][j] = in.colorAt(i, j);
            }
        }
        for (i = 0; i < this.xBins; ++i) {
            for (j = 0; j < this.yBins; ++j) {
                z = this.data[i][j];
                this.data[i][j] = (z - zMin) / (zMax - zMin);
            }
        }
    }

    int xBins() {
        return this.xBins;
    }

    int yBins() {
        return this.yBins;
    }

    float zAt(int xIndex, int yIndex) {
        try {
            return this.data[xIndex][yIndex];
        }
        catch (ArrayIndexOutOfBoundsException x) {
            return 0.0f;
        }
    }

    Color3b colorAt(int xIndex, int yIndex) {
        try {
            return this.color[xIndex][yIndex];
        }
        catch (ArrayIndexOutOfBoundsException x) {
            return null;
        }
    }
}

