/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import javax.vecmath.Color3b;
import org.freehep.j3d.plot.Binned2DData;
import org.freehep.j3d.plot.NormalizedBinned2DData;

class NormalizedBinned2DLogData
extends NormalizedBinned2DData {
    private int xBins;
    private int yBins;
    private float[][] data;
    private Color3b[][] color;

    NormalizedBinned2DLogData(Binned2DData in) {
        super(in);
    }

    @Override
    void initialize(Binned2DData in) {
        this.xBins = in.xBins();
        this.yBins = in.yBins();
        this.data = new float[this.xBins][this.yBins];
        this.color = new Color3b[this.xBins][this.yBins];
        float zMin = Float.MAX_VALUE;
        float zMax = -3.4028235E38f;
        for (int i = 0; i < this.xBins; ++i) {
            for (int j = 0; j < this.yBins; ++j) {
                float z = in.zAt(i, j);
                if (z > 0.0f) {
                    if (z < zMin) {
                        zMin = z;
                    }
                    if (z > zMax) {
                        zMax = z;
                    }
                }
                this.data[i][j] = z;
                this.color[i][j] = in.colorAt(i, j);
            }
        }
        double zMinLog = Math.log(zMin);
        double zMaxLog = Math.log(zMax);
        for (int i = 0; i < this.xBins; ++i) {
            for (int j = 0; j < this.yBins; ++j) {
                float z = this.data[i][j];
                this.data[i][j] = z <= 0.0f ? 0.0f : (float)((Math.log(z) - zMinLog) / (zMaxLog - zMinLog));
            }
        }
    }

    @Override
    int xBins() {
        return this.xBins;
    }

    @Override
    int yBins() {
        return this.yBins;
    }

    @Override
    float zAt(int xIndex, int yIndex) {
        try {
            return this.data[xIndex][yIndex];
        }
        catch (ArrayIndexOutOfBoundsException x) {
            return 0.0f;
        }
    }

    @Override
    Color3b colorAt(int xIndex, int yIndex) {
        try {
            return this.color[xIndex][yIndex];
        }
        catch (ArrayIndexOutOfBoundsException x) {
            return null;
        }
    }
}

