/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.universe.SimpleUniverse;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.freehep.j3d.plot.PlotKeyNavigatorBehavior;

public abstract class Plot3D
extends Canvas3D {
    protected boolean init = false;
    protected boolean parallelProjection = false;
    protected SimpleUniverse universe;
    private Bounds bounds;

    Plot3D() {
        super(SimpleUniverse.getPreferredConfiguration());
    }

    protected void init() {
        Node plot = this.createPlot();
        BranchGroup scene = this.defineMouseBehaviour(plot);
        this.setupLights(scene);
        scene.compile();
        this.universe = new SimpleUniverse((Canvas3D)this);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.universe.addBranchGraph(scene);
        if (this.parallelProjection) {
            this.setProjectionPolicy(this.universe, this.parallelProjection);
        }
        this.init = true;
    }

    public void addNotify() {
        if (!this.init) {
            this.init();
        }
        super.addNotify();
    }

    public boolean getParallelProjection() {
        return this.parallelProjection;
    }

    public void setParallelProjection(boolean b) {
        if (this.parallelProjection != b) {
            this.parallelProjection = b;
            this.setProjectionPolicy(this.universe, this.parallelProjection);
        }
    }

    protected abstract Node createPlot();

    protected BranchGroup defineMouseBehaviour(Node scene) {
        BranchGroup bg = new BranchGroup();
        Bounds bounds = this.getDefaultBounds();
        TransformGroup objTransform = new TransformGroup();
        objTransform.setCapability(18);
        objTransform.setCapability(17);
        objTransform.addChild(scene);
        bg.addChild((Node)objTransform);
        MouseRotate mouseRotate = new MouseRotate();
        mouseRotate.setTransformGroup(objTransform);
        mouseRotate.setSchedulingBounds(bounds);
        bg.addChild((Node)mouseRotate);
        MouseTranslate mouseTranslate = new MouseTranslate();
        mouseTranslate.setTransformGroup(objTransform);
        mouseTranslate.setSchedulingBounds(bounds);
        bg.addChild((Node)mouseTranslate);
        MouseZoom mouseZoom = new MouseZoom();
        mouseZoom.setTransformGroup(objTransform);
        mouseZoom.setSchedulingBounds(bounds);
        bg.addChild((Node)mouseZoom);
        Transform3D trans = this.createDefaultOrientation();
        objTransform.setTransform(trans);
        PlotKeyNavigatorBehavior keyBehavior = new PlotKeyNavigatorBehavior(objTransform, 0.1f, 10.0f);
        objTransform.addChild((Node)keyBehavior);
        keyBehavior.setSchedulingBounds(bounds);
        return bg;
    }

    protected void setupLights(BranchGroup root) {
        DirectionalLight lightD = new DirectionalLight();
        lightD.setDirection(new Vector3f(0.0f, -0.7f, -0.7f));
        lightD.setInfluencingBounds(this.getDefaultBounds());
        root.addChild((Node)lightD);
        DirectionalLight lightD1 = new DirectionalLight();
        lightD1.setDirection(new Vector3f(0.0f, 0.7f, 0.7f));
        lightD1.setInfluencingBounds(this.getDefaultBounds());
        root.addChild((Node)lightD1);
        AmbientLight lightA = new AmbientLight();
        lightA.setInfluencingBounds(this.getDefaultBounds());
        root.addChild((Node)lightA);
    }

    protected Transform3D createDefaultOrientation() {
        Transform3D trans = new Transform3D();
        trans.setIdentity();
        trans.rotX(-0.7853981633974483);
        trans.setTranslation(new Vector3f(0.0f, -0.3f, 0.0f));
        return trans;
    }

    protected void setProjectionPolicy(SimpleUniverse universe, boolean parallelProjection) {
        View view = universe.getViewer().getView();
        if (parallelProjection) {
            view.setProjectionPolicy(0);
        } else {
            view.setProjectionPolicy(1);
        }
    }

    protected Bounds getDefaultBounds() {
        if (this.bounds == null) {
            Point3d center = new Point3d(0.0, 0.0, 0.0);
            this.bounds = new BoundingSphere(center, 10.0);
        }
        return this.bounds;
    }
}

