/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Vector3f;

public class PlotKeyNavigatorBehavior
extends Behavior {
    private Transform3D init;
    private Transform3D tgr = new Transform3D();
    private TransformGroup tg;
    private WakeupOnAWTEvent wup;
    private float step;
    private float angle;

    public PlotKeyNavigatorBehavior(TransformGroup targetTG, float moveStep, float rotStep) {
        this.init = new Transform3D();
        this.tg = targetTG;
        this.wup = new WakeupOnAWTEvent(401);
        this.step = moveStep;
        this.angle = (float)Math.toRadians(rotStep);
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.wup);
        this.tg.getTransform(this.init);
    }

    public void processStimulus(Enumeration criteria) {
        KeyEvent event = (KeyEvent)this.wup.getAWTEvent()[0];
        int keyCode = event.getKeyCode();
        boolean shift = (event.getModifiers() & 1) != 0;
        switch (keyCode) {
            case 38: {
                this.move(0.0f, -1.0f, 0.0f, shift);
                break;
            }
            case 40: {
                this.move(0.0f, 1.0f, 0.0f, shift);
                break;
            }
            case 37: {
                this.move(-1.0f, 0.0f, 0.0f, shift);
                break;
            }
            case 39: {
                this.move(1.0f, 0.0f, 0.0f, shift);
                break;
            }
            case 33: {
                this.move(0.0f, 0.0f, 1.0f, shift);
                break;
            }
            case 34: {
                this.move(0.0f, 0.0f, -1.0f, shift);
                break;
            }
            case 36: {
                this.tg.setTransform(this.init);
            }
        }
        this.wakeupOn((WakeupCondition)this.wup);
    }

    private void move(float x, float y, float z, boolean shift) {
        if (!shift) {
            this.translate(x * this.step, y * this.step, z * this.step);
        } else {
            this.rotate(x * this.angle, y * this.angle, z * this.angle);
        }
    }

    private void translate(float x, float y, float z) {
        Transform3D tr = new Transform3D();
        Vector3f vec = new Vector3f(x, y, z);
        tr.setTranslation(vec);
        this.tg.getTransform(this.tgr);
        this.tgr.mul(tr);
        this.tg.setTransform(this.tgr);
    }

    private void rotate(float x, float y, float z) {
        Transform3D tr = new Transform3D();
        if (x != 0.0f) {
            tr.rotX((double)x);
        }
        if (y != 0.0f) {
            tr.rotY((double)y);
        }
        if (z != 0.0f) {
            tr.rotZ((double)z);
        }
        this.tg.getTransform(this.tgr);
        this.tgr.mul(tr);
        this.tg.setTransform(this.tgr);
    }
}

