/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import javax.vecmath.Color3b;

public class Rainbow {
    private double min;
    private double max;
    private static Color3b[] rtable;

    public Rainbow() {
        this(0.0, 1.0);
    }

    public Rainbow(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public Color3b colorFor(double d) {
        int i = (int)Math.floor((d - this.min) * 100.0 / (this.max - this.min));
        if (i < 0) {
            i = 0;
        } else if (i >= rtable.length) {
            i = rtable.length - 1;
        }
        return rtable[i];
    }

    static {
        byte b;
        byte g;
        byte r;
        int j;
        rtable = new Color3b[100];
        for (j = 0; j < 40; ++j) {
            r = (byte)(255.0 * (1.0 - (double)j / 40.0));
            g = (byte)(255.0 * ((double)j / 40.0));
            b = 0;
            Rainbow.rtable[j] = new Color3b(r, g, b);
        }
        for (j = 40; j < 80; ++j) {
            r = 0;
            g = (byte)((double)(255 * (80 - j)) / 40.0);
            b = (byte)((double)(255 * (j - 40)) / 40.0);
            Rainbow.rtable[j] = new Color3b(r, g, b);
        }
        for (j = 80; j < 100; ++j) {
            r = (byte)((double)(255 * (j - 80)) / 40.0);
            g = 0;
            b = (byte)((double)(255 * (120 - j)) / 40.0);
            Rainbow.rtable[j] = new Color3b(r, g, b);
        }
    }
}

