/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.freehep.j3d.plot.AbstractPlotBuilder;
import org.freehep.j3d.plot.NormalizedBinned2DData;
import org.freehep.j3d.plot.Rainbow;
import org.freehep.j3d.plot.TimeStamp;

public class SurfaceBuilder
extends AbstractPlotBuilder {
    private static final Color3b grey = new Color3b(50, 50, 50);
    private static final Rainbow rainbow = new Rainbow();
    private TimeStamp timeStamp = TimeStamp.sharedInstance();
    private Shape3D shape;

    public Node buildContent(NormalizedBinned2DData data) {
        this.shape = this.createShape();
        this.shape.setCapability(13);
        this.shape.setGeometry(this.buildGeometry(data));
        return this.shape;
    }

    public void updatePlot(NormalizedBinned2DData data) {
        this.shape.setGeometry(this.buildGeometry(data));
    }

    private Geometry buildGeometry(NormalizedBinned2DData data) {
        int i;
        this.timeStamp.print("Starting SurfaceBuilder.buildContent()");
        int nXbins = data.xBins();
        int nYbins = data.yBins();
        float xBinWidth = 1.0f / (float)nXbins;
        float yBinWidth = 1.0f / (float)nYbins;
        Point3d[] bcoord = new Point3d[(nXbins - 1) * (nYbins - 1) * 4];
        Color3b[] bcolor = new Color3b[(nXbins - 1) * (nYbins - 1) * 4];
        for (i = 0; i < (nXbins - 1) * (nYbins - 1) * 4; ++i) {
            bcoord[i] = new Point3d();
            bcolor[i] = new Color3b();
        }
        int bcur = 0;
        int k = 0;
        float x = -0.5f;
        while (k < nXbins - 1) {
            int l = 0;
            float y = -0.5f;
            while (l < nYbins - 1) {
                bcoord[bcur].x = x + xBinWidth / 2.0f;
                bcoord[bcur].y = y + yBinWidth / 2.0f;
                bcoord[bcur].z = data.zAt(k, l);
                bcolor[bcur] = data.colorAt(k, l);
                bcoord[++bcur].x = x + xBinWidth / 2.0f;
                bcoord[bcur].y = y + 1.5f * xBinWidth;
                bcoord[bcur].z = data.zAt(k, l + 1);
                bcolor[bcur] = data.colorAt(k, l + 1);
                bcoord[++bcur].x = x + 1.5f * xBinWidth;
                bcoord[bcur].y = y + 1.5f * yBinWidth;
                bcoord[bcur].z = data.zAt(k + 1, l + 1);
                bcolor[bcur] = data.colorAt(k + 1, l + 1);
                bcoord[++bcur].x = x + 1.5f * xBinWidth;
                bcoord[bcur].y = y + yBinWidth / 2.0f;
                bcoord[bcur].z = data.zAt(k + 1, l);
                bcolor[bcur] = data.colorAt(k + 1, l);
                ++bcur;
                ++l;
                y += yBinWidth;
            }
            ++k;
            x += xBinWidth;
        }
        GeometryInfo geom = new GeometryInfo(2);
        geom.setCoordinates(bcoord);
        geom.setColors(bcolor);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(geom);
        Vector3f[] normals = geom.getNormals();
        for (i = 0; i < normals.length; ++i) {
            normals[i].x = -normals[i].x;
            normals[i].y = -normals[i].y;
            normals[i].z = -normals[i].z;
        }
        geom.setNormals(normals);
        Stripifier st = new Stripifier();
        st.stripify(geom);
        geom.recomputeIndices();
        System.out.print("Surface geometry done.\n");
        this.timeStamp.print("finished, now finalizing, point count = " + bcur);
        return geom.getGeometryArray();
    }

    Shape3D createShape() {
        Shape3D surface = new Shape3D();
        this.timeStamp.print("geometry set");
        surface.setAppearance(this.createMaterialAppearance());
        return surface;
    }

    private Appearance createMaterialAppearance() {
        Appearance materialAppear = new Appearance();
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCullFace(0);
        materialAppear.setPolygonAttributes(polyAttrib);
        Material material = new Material();
        material.setDiffuseColor(new Color3f(1.0f, 0.0f, 0.0f));
        materialAppear.setMaterial(material);
        return materialAppear;
    }
}

