/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot;

import javax.media.j3d.Group;
import javax.media.j3d.Node;
import org.freehep.j3d.plot.AxisBuilder;
import org.freehep.j3d.plot.Binned2DData;
import org.freehep.j3d.plot.NormalizedBinned2DData;
import org.freehep.j3d.plot.NormalizedBinned2DLogData;
import org.freehep.j3d.plot.Plot3D;
import org.freehep.j3d.plot.SurfaceBuilder;
import org.freehep.j3d.plot.XAxisBuilder;
import org.freehep.j3d.plot.YAxisBuilder;
import org.freehep.j3d.plot.ZAxisBuilder;

public class SurfacePlot
extends Plot3D {
    private Binned2DData data;
    private SurfaceBuilder builder;
    private Node plot;
    private boolean logZscaling = false;
    private AxisBuilder xAxis;
    private AxisBuilder yAxis;
    private ZAxisBuilder zAxis;
    private String xAxisLabel = "X Axis";
    private String yAxisLabel = "Y Axis";
    private String zAxisLabel = "Z Axis";
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double zmin;
    private double zmax;

    public void setData(Binned2DData data) {
        this.data = data;
        if (this.init) {
            if ((double)data.xMin() != this.xmin || (double)data.xMax() != this.xmax) {
                this.xmin = data.xMin();
                this.xmax = data.xMax();
                this.xAxis.createLabelsNTicks(this.xmin, this.xmax);
                this.xAxis.apply();
            }
            if ((double)data.yMin() != this.ymin || (double)data.yMax() != this.ymax) {
                this.ymin = data.yMin();
                this.ymax = data.yMax();
                this.yAxis.createLabelsNTicks(this.ymin, this.ymax);
                this.yAxis.apply();
            }
            if ((double)data.zMin() != this.zmin || (double)data.zMax() != this.zmax) {
                this.zmin = data.zMin();
                this.zmax = data.zMax();
                this.zAxis.createLabelsNTicks(this.zmin, this.zmax, this.logZscaling);
                this.zAxis.apply();
            }
            if (this.logZscaling) {
                this.builder.updatePlot(new NormalizedBinned2DLogData(data));
            } else {
                this.builder.updatePlot(new NormalizedBinned2DData(data));
            }
        }
    }

    public boolean getLogZscaling() {
        return this.logZscaling;
    }

    public void setLogZscaling(boolean b) {
        if (this.logZscaling != b) {
            this.logZscaling = b;
            if (this.data != null) {
                this.zmin = this.data.zMin();
                this.zmax = this.data.zMax();
                this.zAxis.createLabelsNTicks(this.zmin, this.zmax, this.logZscaling);
                this.zAxis.apply();
                if (this.logZscaling) {
                    this.builder.updatePlot(new NormalizedBinned2DLogData(this.data));
                } else {
                    this.builder.updatePlot(new NormalizedBinned2DData(this.data));
                }
            }
        }
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String s) {
        this.xAxisLabel = s;
        this.xAxis.setLabel(s);
        this.xAxis.apply();
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public void setYAxisLabel(String s) {
        this.yAxisLabel = s;
        this.yAxis.setLabel(s);
        this.yAxis.apply();
    }

    public String getZAxisLabel() {
        return this.zAxisLabel;
    }

    public void setZAxisLabel(String s) {
        this.zAxisLabel = s;
        this.zAxis.setLabel(s);
        this.zAxis.apply();
    }

    @Override
    protected Node createPlot() {
        this.builder = new SurfaceBuilder();
        Node box = this.builder.buildOutsideBox();
        this.plot = this.logZscaling ? this.builder.buildContent(new NormalizedBinned2DLogData(this.data)) : this.builder.buildContent(new NormalizedBinned2DData(this.data));
        double[] tick = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        String[] labels = new String[]{"0.0", "0.2", "0.4", "0.6", "0.8", "1.0"};
        this.xAxis = new XAxisBuilder(this.xAxisLabel, labels, tick);
        this.yAxis = new YAxisBuilder(this.yAxisLabel, labels, tick);
        this.zAxis = new ZAxisBuilder(this.zAxisLabel, labels, tick);
        this.xAxis.createLabelsNTicks(this.data.xMin(), this.data.xMax());
        this.yAxis.createLabelsNTicks(this.data.yMin(), this.data.yMax());
        this.zAxis.createLabelsNTicks(this.data.zMin(), this.data.zMax(), this.logZscaling);
        this.xAxis.apply();
        this.yAxis.apply();
        this.zAxis.apply();
        Group g = new Group();
        g.addChild(box);
        g.addChild(this.plot);
        g.addChild(this.xAxis.getNode());
        g.addChild(this.yAxis.getNode());
        g.addChild(this.zAxis.getNode());
        return g;
    }
}

