/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.freehep.j3d.plot.LegoPlot;
import org.freehep.j3d.plot.SurfacePlot;
import org.freehep.j3d.plot.demo.LegoControlPanel;
import org.freehep.j3d.plot.demo.TestBinned2DData;

public class DemoGUI
extends JPanel {
    private static JPanel panel;
    private static LegoPlot lego;
    private static SurfacePlot surf;

    public DemoGUI() throws IOException {
        super(new BorderLayout());
        lego = new LegoPlot();
        lego.setDrawBlocks(true);
        lego.setLinesWhileAnim(true);
        lego.setSparsifyThreshold(600);
        lego.setData(new TestBinned2DData());
        LegoControlPanel controls = new LegoControlPanel(lego);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)lego), "Center");
        panel.add((Component)controls, "South");
        this.add((Component)panel, "Center");
        JTextPane label = new JTextPane();
        label.setContentType("text/html");
        label.setText("<html><font color=\"black\">This three-dimensional graph plots 2-dimensional binned data.  For each bin (x,y) there is a corresponding z value, plotted as the height of the bin.  There are three representations, the lego plot, which shows each bin as a box, the line plot, which shows each bin as a vertical line, and the surface plot, which makes a surface of the heights of the bins.<p>The plots can be rotated using the first mouse button.  They can be panned (moved around) using the right mouse button.  To zoom in or out, use the middle mouse button.  Alternatively, you can use the arrow keys and the page up/down keys for panning in specific directions. Use the same keys while holding the shift key down for rotations.  Use the Home key to restore the original orientation. <p>Some systems have trouble keeping up with the movements of the lego plot, so animation options are available to show a simpler version of the plot while the mouse button is depressed.  To enter a new sparsification threshold, type the number followed by the Enter key.<p>Other options inlude a log scale for the z axis and a parallel projection instead of the default perspective projection.<p>The labels for the axes can also be changed.  Type the new axis text followed by the Enter key.");
        JScrollPane scroll = new JScrollPane(label);
        scroll.setPreferredSize(new Dimension(250, 600));
        this.add((Component)scroll, "East");
    }

    public static SurfacePlot getSurfacePlot() throws IOException {
        if (surf == null) {
            surf = new SurfacePlot();
            surf.setData(new TestBinned2DData());
        }
        panel.remove((Component)((Object)lego));
        panel.add((Component)((Object)surf), "Center");
        panel.revalidate();
        panel.repaint();
        return surf;
    }

    public static LegoPlot getLegoPlot() {
        panel.remove((Component)((Object)surf));
        panel.add((Component)((Object)lego), "Center");
        panel.revalidate();
        panel.repaint();
        return lego;
    }

    public static void main(String[] args) throws IOException {
        JFrame f = new JFrame("3D Lego Demo");
        f.setContentPane(new DemoGUI());
        f.setSize(new Dimension(600, 600));
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    static {
        surf = null;
    }
}

