/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.freehep.j3d.plot.LegoPlot;
import org.freehep.j3d.plot.Plot3D;
import org.freehep.j3d.plot.SurfacePlot;
import org.freehep.j3d.plot.demo.DemoGUI;

public class LegoControlPanel
extends JPanel {
    private ButtonGroup buttonGroup1;
    private JPanel PlotTypePanel;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JPanel OptionPanel;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JPanel AnimationPanel;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JPanel jPanel5;
    private JLabel jLabel4;
    private JTextField jTextField4;
    private JPanel AxisLabelPanel;
    private JLabel jLabel1;
    private JTextField jTextField1;
    private JLabel jLabel2;
    private JTextField jTextField2;
    private JLabel jLabel3;
    private JTextField jTextField3;
    private LegoPlot lego;
    private SurfacePlot surf;
    private Plot3D plot;
    private int savedSparsThreshold;

    public LegoControlPanel(LegoPlot plot) {
        this.lego = plot;
        this.plot = plot;
        this.initComponents();
        this.savedSparsThreshold = this.lego.getSparsifyThreshold();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.PlotTypePanel = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.OptionPanel = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.AnimationPanel = new JPanel();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jTextField4 = new JTextField();
        this.AxisLabelPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextField3 = new JTextField();
        this.setLayout(new BorderLayout());
        this.PlotTypePanel.setLayout(new FlowLayout(1, 5, 0));
        this.PlotTypePanel.setBorder(new TitledBorder("Plot Type"));
        this.jRadioButton1.setSelected(this.lego.getDrawBlocks());
        this.jRadioButton1.setText("Lego Plot");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.PlotTypePanel.add(this.jRadioButton1);
        this.jRadioButton2.setToolTipText("a lego with vertical lines instead of boxes");
        this.jRadioButton2.setSelected(!this.lego.getDrawBlocks());
        this.jRadioButton2.setText("Line Plot");
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.PlotTypePanel.add(this.jRadioButton2);
        this.jRadioButton3.setText("Surface Plot");
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.PlotTypePanel.add(this.jRadioButton3);
        this.add((Component)this.PlotTypePanel, "North");
        this.OptionPanel.setLayout(new BoxLayout(this.OptionPanel, 1));
        this.OptionPanel.setBorder(new TitledBorder("Options"));
        this.jCheckBox1.setSelected(this.lego.getLogZscaling());
        this.jCheckBox1.setText("Log Z Axis");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.OptionPanel.add(this.jCheckBox1);
        this.jCheckBox2.setToolTipText("Perspective or Parallel projection");
        this.jCheckBox2.setSelected(!this.lego.getParallelProjection());
        this.jCheckBox2.setText("Perspective");
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.JCheckBox2ActionPerformed(evt);
            }
        });
        this.OptionPanel.add(this.jCheckBox2);
        this.add((Component)this.OptionPanel, "West");
        this.AnimationPanel.setLayout(new BoxLayout(this.AnimationPanel, 1));
        this.AnimationPanel.setBorder(new TitledBorder("Animation"));
        this.jCheckBox3.setSelected(this.lego.getLinesWhileAnim());
        this.jCheckBox3.setText("Lines while animating");
        this.jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.jCheckBox3ActionPerformed(evt);
            }
        });
        this.AnimationPanel.add(this.jCheckBox3);
        this.jCheckBox4.setSelected(true);
        this.jCheckBox4.setText("Sparsification");
        this.jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.jCheckBox4ActionPerformed(evt);
            }
        });
        this.AnimationPanel.add(this.jCheckBox4);
        this.jPanel5.setAlignmentX(0.0f);
        this.jLabel4.setText("Threshold");
        this.jLabel4.setToolTipText("Suggested # wire bins to draw when sparsifying");
        this.jLabel4.setForeground(Color.black);
        this.jPanel5.add(this.jLabel4);
        this.jTextField4.setColumns(8);
        this.jTextField4.setText(String.valueOf(this.lego.getSparsifyThreshold()));
        this.jTextField4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.jTextField4ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jTextField4);
        this.AnimationPanel.add(this.jPanel5);
        this.add((Component)this.AnimationPanel, "Center");
        this.AxisLabelPanel.setLayout(new GridBagLayout());
        this.AxisLabelPanel.setBorder(new TitledBorder("Axis Labels"));
        this.jLabel1.setText("X");
        this.jLabel1.setForeground(Color.black);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        this.AxisLabelPanel.add((Component)this.jLabel1, gridBagConstraints1);
        this.jTextField1.setToolTipText("Type a new X Axis Label & press Enter");
        this.jTextField1.setColumns(20);
        this.jTextField1.setText(this.lego.getXAxisLabel());
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        this.AxisLabelPanel.add((Component)this.jTextField1, gridBagConstraints1);
        this.jLabel2.setText("Y");
        this.jLabel2.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        this.AxisLabelPanel.add((Component)this.jLabel2, gridBagConstraints1);
        this.jTextField2.setToolTipText("Type a new Y Axis Label & press Enter");
        this.jTextField2.setColumns(20);
        this.jTextField2.setText(this.lego.getYAxisLabel());
        this.jTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.jTextField2ActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        this.AxisLabelPanel.add((Component)this.jTextField2, gridBagConstraints1);
        this.jLabel3.setText("Z");
        this.jLabel3.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        this.AxisLabelPanel.add((Component)this.jLabel3, gridBagConstraints1);
        this.jTextField3.setToolTipText("Type a new Z Axis Label & press Enter");
        this.jTextField3.setColumns(20);
        this.jTextField3.setText(this.lego.getZAxisLabel());
        this.jTextField3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegoControlPanel.this.jTextField3ActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        this.AxisLabelPanel.add((Component)this.jTextField3, gridBagConstraints1);
        this.add((Component)this.AxisLabelPanel, "South");
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        if (this.jRadioButton3.isSelected()) {
            try {
                this.surf = DemoGUI.getSurfacePlot();
                this.plot = this.surf;
                this.surf.setLogZscaling(this.jCheckBox1.isSelected());
                this.surf.setParallelProjection(!this.jCheckBox2.isSelected());
                this.surf.setXAxisLabel(this.jTextField1.getText());
                this.surf.setYAxisLabel(this.jTextField2.getText());
                this.surf.setZAxisLabel(this.jTextField3.getText());
                this.jCheckBox3.setEnabled(false);
                this.jCheckBox4.setEnabled(false);
                this.jLabel4.setEnabled(false);
                this.jTextField4.setEnabled(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jCheckBox4ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox4.isSelected()) {
            this.jTextField4.setEnabled(true);
            this.jLabel4.setEnabled(true);
            try {
                int i = Integer.getInteger(this.jTextField4.getText());
                this.lego.setSparsifyThreshold(i == Integer.MAX_VALUE ? this.savedSparsThreshold : i);
            }
            catch (Exception e) {
                this.jTextField4.setText("600");
                this.lego.setSparsifyThreshold(600);
            }
        } else {
            this.jTextField4.setEnabled(false);
            this.jLabel4.setEnabled(false);
            this.savedSparsThreshold = this.lego.getSparsifyThreshold();
            this.lego.setSparsifyThreshold(Integer.MAX_VALUE);
        }
    }

    private void JCheckBox2ActionPerformed(ActionEvent evt) {
        this.plot.setParallelProjection(!this.jCheckBox2.isSelected());
    }

    private void jTextField3ActionPerformed(ActionEvent evt) {
        if (this.plot instanceof SurfacePlot) {
            this.surf.setZAxisLabel(this.jTextField3.getText());
        } else {
            this.lego.setZAxisLabel(this.jTextField3.getText());
        }
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
        if (this.plot instanceof SurfacePlot) {
            this.surf.setYAxisLabel(this.jTextField2.getText());
        } else {
            this.lego.setYAxisLabel(this.jTextField2.getText());
        }
    }

    private void jCheckBox3ActionPerformed(ActionEvent evt) {
        this.lego.setLinesWhileAnim(this.jCheckBox3.isSelected());
        if (!this.jCheckBox3.isSelected()) {
            this.jCheckBox4.setEnabled(false);
            this.jLabel4.setEnabled(false);
            this.jTextField4.setEnabled(false);
        } else {
            this.jTextField4.setEnabled(true);
            this.jLabel4.setEnabled(true);
            int i = this.lego.getSparsifyThreshold();
            this.jTextField4.setText(Integer.toString(i == Integer.MAX_VALUE ? this.savedSparsThreshold : i));
            this.jCheckBox4.setSelected(true);
        }
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.plot instanceof SurfacePlot) {
            this.surf.setLogZscaling(this.jCheckBox1.isSelected());
        } else {
            this.lego.setLogZscaling(this.jCheckBox1.isSelected());
        }
    }

    private void jTextField4ActionPerformed(ActionEvent evt) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);
        integerFormatter.setParseIntegerOnly(true);
        int retVal = 600;
        try {
            retVal = integerFormatter.parse(this.jTextField4.getText()).intValue();
        }
        catch (ParseException e) {
            toolkit.beep();
            this.jTextField4.setText("600");
        }
        this.jTextField4.setText(Integer.toString(retVal));
        this.lego.setSparsifyThreshold(retVal);
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        if (this.plot instanceof SurfacePlot) {
            this.surf.setXAxisLabel(this.jTextField1.getText());
        } else {
            this.lego.setXAxisLabel(this.jTextField1.getText());
        }
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        if (this.jRadioButton2.isSelected()) {
            this.lego.setDrawBlocks(false);
            this.setPlotToLego();
            this.jCheckBox3.setEnabled(false);
        }
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        if (this.jRadioButton1.isSelected()) {
            this.lego.setDrawBlocks(true);
            this.jCheckBox3.setEnabled(true);
            this.setPlotToLego();
        }
    }

    private void setPlotToLego() {
        if (this.plot instanceof SurfacePlot) {
            this.lego.setLogZscaling(this.jCheckBox1.isSelected());
            this.lego.setParallelProjection(!this.jCheckBox2.isSelected());
            this.lego.setXAxisLabel(this.jTextField1.getText());
            this.lego.setYAxisLabel(this.jTextField2.getText());
            this.lego.setZAxisLabel(this.jTextField3.getText());
            this.plot = DemoGUI.getLegoPlot();
            this.jCheckBox3.setEnabled(true);
            this.jCheckBox4.setEnabled(true);
            this.jLabel4.setEnabled(true);
            this.jTextField4.setEnabled(true);
        }
    }
}

