/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.j3d.plot.demo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.vecmath.Color3b;
import org.freehep.j3d.plot.Binned2DData;
import org.freehep.j3d.plot.Rainbow;

public class TestBinned2DData
implements Binned2DData {
    private int xBins;
    private int yBins;
    private Rainbow rainbow = new Rainbow();
    private float[][] data;

    public TestBinned2DData() throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("test.data")));
        this.xBins = Integer.parseInt(in.readLine());
        this.yBins = Integer.parseInt(in.readLine());
        this.data = new float[this.xBins][this.yBins];
        for (int i = 0; i < this.xBins; ++i) {
            for (int j = 0; j < this.yBins; ++j) {
                this.data[i][j] = Float.parseFloat(in.readLine());
            }
        }
        in.close();
    }

    @Override
    public int xBins() {
        return this.xBins;
    }

    @Override
    public int yBins() {
        return this.yBins;
    }

    @Override
    public float xMin() {
        return 0.0f;
    }

    @Override
    public float xMax() {
        return 1.0f;
    }

    @Override
    public float yMin() {
        return 0.0f;
    }

    @Override
    public float yMax() {
        return 1.0f;
    }

    @Override
    public float zMin() {
        return 0.0f;
    }

    @Override
    public float zMax() {
        return 1.0f;
    }

    @Override
    public float zAt(int xIndex, int yIndex) {
        return this.data[xIndex][yIndex];
    }

    @Override
    public Color3b colorAt(int xIndex, int yIndex) {
        return this.rainbow.colorFor(this.zAt(xIndex, yIndex));
    }
}

