/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.swing.driver.g5;

import com.ur.util.logging.Log;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.jemmy.ComponentChooser;

public class URCapComponentChooser
implements ComponentChooser {
    private final Class type;
    private final String name;
    private final String title;
    private final boolean showing;
    private boolean dump;

    public URCapComponentChooser(Class type, String name, String title, boolean showing) {
        this.type = type;
        this.name = name;
        this.title = title;
        this.showing = showing;
        this.dump = false;
    }

    public void enableDump() {
        this.dump = true;
    }

    public void disableDump() {
        this.dump = false;
    }

    public boolean checkComponent(Component component) {
        this.dumpInfo(component);
        String thisTitle = null;
        if (JButton.class.isAssignableFrom(component.getClass())) {
            thisTitle = ((JButton)component).getText();
        }
        boolean check = true;
        if (this.type != null && !this.type.isAssignableFrom(component.getClass())) {
            check = false;
        }
        if (this.name != null && !this.name.equals(component.getName())) {
            check = false;
        }
        if (component.isShowing() != this.showing) {
            check = false;
        }
        if (this.title != null && !this.title.equals(thisTitle)) {
            check = false;
        }
        return check;
    }

    private void dumpInfo(Component component) {
        if (this.dump && component.isShowing() && this.type.isAssignableFrom(component.getClass())) {
            Log.info((String)("FOUND " + component));
            Log.info((String)("TYPE " + component.getClass().getSimpleName()));
            Log.info((String)("NAME " + component.getName()));
            Log.info((String)("SHOWING " + component.isShowing()));
            if (AbstractButton.class.isAssignableFrom(component.getClass())) {
                Log.info((String)("TITLE=" + ((AbstractButton)component).getText()));
            }
        }
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("class:=");
        if (this.type == null) {
            sb.append("ANY");
        } else {
            sb.append(this.type.getSimpleName());
        }
        sb.append(", name=");
        if (this.name == null) {
            sb.append("ANY");
        } else {
            sb.append(this.name);
        }
        sb.append(", showing=");
        sb.append(this.showing);
        return sb.toString();
    }
}

