/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.swing.driver.g5;

import com.google.inject.Inject;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.urcaps.swing.driver.g5.URCapComponentChooser;
import javax.swing.JButton;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.ContainerOperator;

public class URCapProgramScreenDriver
extends BaseDriver {
    private static final String PROGRAM_SCREEN = "programScreen.HeaderMenu";
    private static final String URCAP_NODE_SECTION = "uRCapsNodesSection.ProgramTab";
    private static final String WIZARD_NODE_SECTION = "wizardNodesSection.ProgramTab";

    @Inject
    protected URCapProgramScreenDriver(MainScreen mainScreen, String driverShowingComponentName) {
        super(mainScreen, driverShowingComponentName);
    }

    public void goToProgramScreen() {
        this.push(this.buttonNamed(PROGRAM_SCREEN));
    }

    public void goToURCapsSection() {
        this.push(this.buttonNamed(URCAP_NODE_SECTION));
    }

    public void goToWizardSection() {
        this.push(this.buttonNamed(WIZARD_NODE_SECTION));
    }

    public void openWizard(String title) {
        this.push(this.buttonNamed("wizardNodesSection.ProgramTab." + title));
    }

    public void openUrcap(String title) {
        this.push(this.buttonNamed("uRCapsNodesSection.ProgramTab." + title));
    }

    public void pushButtonWithTitle(String title) {
        AbstractButtonOperator button = new AbstractButtonOperator((ContainerOperator)this.mainScreen, URCapProgramScreenDriver.createChooser(JButton.class, null, title, true));
        this.push(button);
    }

    public void selectRobotProgram() {
        this.treeNamed("programTree.ProgramPanel").selectRow(1);
    }

    public static ComponentChooser createChooser(Class type, String name, String title, Boolean showing) {
        return new URCapComponentChooser(type, name, title, showing);
    }
}

