/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.i18n;

import com.energid.urcap.remotetcp.i18n.LanguagePack;
import com.energid.urcap.remotetcp.i18n.UTF8Control;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.Locale;
import java.util.ResourceBundle;

public class TextResource {
    private static final String fileName = "text/text";
    private ResourceBundle resource;

    public TextResource(Locale locale) {
        locale = locale.equals(LanguagePack.rootLanguageLocale) ? Locale.ROOT : locale;
        this.resource = ResourceBundle.getBundle(fileName, locale, new UTF8Control());
    }

    public String systemOfMeasurement(UnitType unitType) {
        if (unitType == UnitType.METRIC) {
            return this.getStringByKey("Metric_Units");
        }
        return this.getStringByKey("US_Units");
    }

    public String lengthUnitName(Length.Unit unit) {
        if (unit == Length.Unit.MM) {
            return this.getStringByKey("Millimeter");
        }
        return this.getStringByKey("Inch");
    }

    public String getStringByKey(String key) {
        try {
            return this.resource.getString(key);
        }
        catch (Exception e) {
            return "!" + key;
        }
    }
}

