/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPoseCollectionHandler;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.tcp.TCPModel;
import com.ur.urcap.api.domain.value.PoseFactory;

public class RegularTcpCollectionHandler
extends RtcpNamedPoseCollectionHandler {
    private TCPModel tcpModel;

    public RegularTcpCollectionHandler(TCPModel tcpModel, DataModel dataModel, String poseNamePrefix, PoseFactory poseFactory) {
        super(dataModel, poseNamePrefix, poseFactory);
        this.tcpModel = tcpModel;
    }

    @Override
    public String[] getAvailablePoses() {
        String[] tcpNames = new String[]{};
        try {
            tcpNames = new String[this.tcpModel.getTCPs().size()];
            int index = 0;
            for (TCP tcp : this.tcpModel.getTCPs()) {
                tcpNames[index++] = tcp.getDisplayName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tcpNames;
    }

    @Override
    public RtcpNamedPose getNamedPoseById(String id) {
        RtcpNamedPose retNamedPose = null;
        for (TCP tcp : this.tcpModel.getTCPs()) {
            if (!tcp.getDisplayName().equals(id)) continue;
            retNamedPose = new RtcpNamedPose(tcp.getDisplayName(), tcp.getOffset());
        }
        return retNamedPose;
    }

    @Override
    public String getDefaultNamedPose() {
        return this.defaultNamedPose;
    }
}

